/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.internal;

import io.snappydata.Constant$;
import io.snappydata.ToolsCallback;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.spark.Logging;
import org.apache.spark.Logging$class;
import org.apache.spark.SparkContext;
import org.apache.spark.TaskContext;
import org.apache.spark.sql.SnappyContext$;
import org.apache.spark.sql.collection.ExecutorLocalPartition;
import org.apache.spark.sql.collection.ToolsCallbackInit$;
import org.apache.spark.sql.collection.Utils$;
import org.apache.spark.util.MutableURLClassLoader;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.concurrent.Map;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.TraitSetter;

public final class ContextJarUtils$
implements Logging {
    public static final ContextJarUtils$ MODULE$;
    private final String JAR_PATH;
    private final Map<String, URLClassLoader> driverJars;
    private transient Logger org$apache$spark$Logging$$log_;
    private transient int org$apache$spark$Logging$$levelFlags;

    static {
        new ContextJarUtils$();
    }

    @Override
    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    @Override
    @TraitSetter
    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    @Override
    public int org$apache$spark$Logging$$levelFlags() {
        return this.org$apache$spark$Logging$$levelFlags;
    }

    @Override
    public void org$apache$spark$Logging$$levelFlags_$eq(int x$1) {
        this.org$apache$spark$Logging$$levelFlags = x$1;
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public Logger log() {
        return Logging$class.log(this);
    }

    @Override
    public final boolean isInfoEnabled() {
        return Logging$class.isInfoEnabled(this);
    }

    @Override
    public final boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public final boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging$class.initializeLogIfNecessary(this, isInterpreter);
    }

    public SparkContext sparkContext() {
        return SnappyContext$.MODULE$.globalSparkContext();
    }

    public String JAR_PATH() {
        return this.JAR_PATH;
    }

    /*
     * WARNING - void declaration
     */
    public File jarDir() {
        void var1_1;
        File jarDirectory = new File(System.getProperty("user.dir"), this.JAR_PATH());
        Object object = jarDirectory.exists() ? BoxedUnit.UNIT : BoxesRunTime.boxToBoolean((boolean)jarDirectory.mkdir());
        return var1_1;
    }

    private Map<String, URLClassLoader> driverJars() {
        return this.driverJars;
    }

    public Option<URLClassLoader> addDriverJar(String key, URLClassLoader classLoader) {
        return this.driverJars().putIfAbsent((Object)key, (Object)classLoader);
    }

    public void addIfNotPresent(String key, URL[] urls, ClassLoader parent) {
        if (this.driverJars().get((Object)key).isEmpty()) {
            this.driverJars().putIfAbsent((Object)key, (Object)new MutableURLClassLoader(urls, parent));
        }
    }

    public Option<URLClassLoader> removeDriverJar(String key) {
        return this.driverJars().remove((Object)key);
    }

    public Option<URLClassLoader> getDriverJar(String key) {
        return this.driverJars().get((Object)key);
    }

    public void addToSparkJars(String prefix, String path) {
        ToolsCallback callbacks = ToolsCallbackInit$.MODULE$.toolsCallback();
        if (callbacks == null) {
            this.sparkContext().addJar(path);
        } else {
            String localName = (String)Predef$.MODULE$.refArrayOps((Object[])path.split("/")).last();
            String changedFileName = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{prefix, localName}));
            this.logInfo((Function0<String>)new Serializable(path){
                public static final long serialVersionUID = 0L;
                private final String path$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"Adding jar to sc from driver loader").append((Object)this.path$1).toString();
                }
                {
                    this.path$1 = path$1;
                }
            });
            File changedFile = new File(this.jarDir(), changedFileName);
            if (changedFile.exists()) {
                this.sparkContext().addJar(changedFile.getPath());
                this.sparkContext().setLocalProperty(Constant$.MODULE$.CHANGEABLE_JAR_NAME(), changedFile.getPath());
            } else {
                File newFile = callbacks.doFetchFile(path, this.jarDir(), changedFileName);
                this.sparkContext().addJar(newFile.getPath());
                this.sparkContext().setLocalProperty(Constant$.MODULE$.CHANGEABLE_JAR_NAME(), newFile.getPath());
            }
        }
    }

    public void removeFromSparkJars(String prefix, String path) {
        ToolsCallback callbacks = ToolsCallbackInit$.MODULE$.toolsCallback();
        if (callbacks != null) {
            String localName = (String)Predef$.MODULE$.refArrayOps((Object[])path.split("/")).last();
            String changedFileName = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{prefix, localName}));
            File jarFile = new File(this.jarDir(), changedFileName);
            Object object = jarFile.exists() ? BoxesRunTime.boxToBoolean((boolean)jarFile.delete()) : BoxedUnit.UNIT;
            Seq keyToRemove = (Seq)this.sparkContext().listJars().filter((Function1)new Serializable(jarFile){
                public static final long serialVersionUID = 0L;
                private final File jarFile$1;

                public final boolean apply(String x$1) {
                    String string = ContextJarUtils$.MODULE$.org$apache$spark$sql$internal$ContextJarUtils$$getName$1(x$1);
                    String string2 = ContextJarUtils$.MODULE$.org$apache$spark$sql$internal$ContextJarUtils$$getName$1(this.jarFile$1.getPath());
                    return !(string != null ? !string.equals(string2) : string2 != null);
                }
                {
                    this.jarFile$1 = jarFile$1;
                }
            });
            if (keyToRemove.nonEmpty()) {
                this.logInfo((Function0<String>)new Serializable(path){
                    public static final long serialVersionUID = 0L;
                    private final String path$2;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Removing ", " from Spark Jars by Driver loader"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.path$2}));
                    }
                    {
                        this.path$2 = path$2;
                    }
                });
                callbacks.removeAddedJar(this.sparkContext(), (String)keyToRemove.head());
            }
            Utils$.MODULE$.mapExecutors(this.sparkContext(), new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Iterator<Object> apply(TaskContext x$2, ExecutorLocalPartition x$3) {
                    return ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1}))).iterator();
                }
            }, ClassTag$.MODULE$.Int()).count();
        }
    }

    public final String org$apache$spark$sql$internal$ContextJarUtils$$getName$1(String path) {
        return new File(path).getName();
    }

    private ContextJarUtils$() {
        MODULE$ = this;
        Logging$class.$init$(this);
        this.JAR_PATH = "snappy-jars";
        this.driverJars = (Map)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(new ConcurrentHashMap()).asScala();
    }
}

