/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.internal;

import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SnappySession$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.CacheManager;
import org.apache.spark.storage.StorageLevel;
import scala.Option;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001a4Q!\u0001\u0002\u0001\t1\u0011!c\u00158baBL8)Y2iK6\u000bg.Y4fe*\u00111\u0001B\u0001\tS:$XM\u001d8bY*\u0011QAB\u0001\u0004gFd'BA\u0004\t\u0003\u0015\u0019\b/\u0019:l\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0014\u0005\u0001i\u0001C\u0001\b\u0012\u001b\u0005y!B\u0001\t\u0005\u0003%)\u00070Z2vi&|g.\u0003\u0002\u0013\u001f\ta1)Y2iK6\u000bg.Y4fe\"AA\u0003\u0001B\u0001B\u0003%a#A\u0005tKN\u001c\u0018n\u001c8JI\u000e\u0001\u0001CA\f\u001b\u001b\u0005A\"\"A\r\u0002\u000bM\u001c\u0017\r\\1\n\u0005mA\"aA%oi\")Q\u0004\u0001C\u0001=\u00051A(\u001b8jiz\"\"aH\u0011\u0011\u0005\u0001\u0002Q\"\u0001\u0002\t\u000bQa\u0002\u0019\u0001\f\t\u000b\r\u0002A\u0011\t\u0013\u0002\u0015\r\f7\r[3Rk\u0016\u0014\u0018\u0010\u0006\u0003&Qi2\u0005CA\f'\u0013\t9\u0003D\u0001\u0003V]&$\b\"B\u0015#\u0001\u0004Q\u0013!B9vKJL\bGA\u00162!\raSfL\u0007\u0002\t%\u0011a\u0006\u0002\u0002\b\t\u0006$\u0018m]3u!\t\u0001\u0014\u0007\u0004\u0001\u0005\u0013IB\u0013\u0011!A\u0001\u0006\u0003\u0019$aA0%cE\u0011Ag\u000e\t\u0003/UJ!A\u000e\r\u0003\u000f9{G\u000f[5oOB\u0011q\u0003O\u0005\u0003sa\u00111!\u00118z\u0011\u001dY$\u0005%AA\u0002q\n\u0011\u0002^1cY\u0016t\u0015-\\3\u0011\u0007]it(\u0003\u0002?1\t1q\n\u001d;j_:\u0004\"\u0001Q\"\u000f\u0005]\t\u0015B\u0001\"\u0019\u0003\u0019\u0001&/\u001a3fM&\u0011A)\u0012\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\tC\u0002bB$#!\u0003\u0005\r\u0001S\u0001\rgR|'/Y4f\u0019\u00164X\r\u001c\t\u0003\u00132k\u0011A\u0013\u0006\u0003\u0017\u001a\tqa\u001d;pe\u0006<W-\u0003\u0002N\u0015\na1\u000b^8sC\u001e,G*\u001a<fY\")q\n\u0001C!!\u0006aQO\\2bG\",\u0017+^3ssR\u0019\u0011\u000b\u0016.\u0011\u0005]\u0011\u0016BA*\u0019\u0005\u001d\u0011un\u001c7fC:DQ!\u000b(A\u0002U\u0003$A\u0016-\u0011\u00071js\u000b\u0005\u000211\u0012I\u0011\fVA\u0001\u0002\u0003\u0015\ta\r\u0002\u0004?\u0012\u0012\u0004bB.O!\u0003\u0005\r!U\u0001\tE2|7m[5oO\")Q\f\u0001C!=\u0006Q1\r\\3be\u000e\u000b7\r[3\u0015\u0003\u0015BQ\u0001\u0019\u0001\u0005B\u0005\fq\"\u001b8wC2LG-\u0019;f\u0007\u0006\u001c\u0007.\u001a\u000b\u0003K\tDQaY0A\u0002\u0011\fA\u0001\u001d7b]B\u0011Q\r\\\u0007\u0002M*\u0011q\r[\u0001\bY><\u0017nY1m\u0015\tI'.A\u0003qY\u0006t7O\u0003\u0002l\t\u0005A1-\u0019;bYf\u001cH/\u0003\u0002nM\nYAj\\4jG\u0006d\u0007\u000b\\1o\u0011\u0015y\u0007\u0001\"\u0011q\u0003QIgN^1mS\u0012\fG/Z\"bG\",G\rU1uQR\u0019Q%\u001d<\t\u000bIt\u0007\u0019A:\u0002\u0019M\u0004\u0018M]6TKN\u001c\u0018n\u001c8\u0011\u00051\"\u0018BA;\u0005\u00051\u0019\u0006/\u0019:l'\u0016\u001c8/[8o\u0011\u00159h\u000e1\u0001@\u00031\u0011Xm]8ve\u000e,\u0007+\u0019;i\u0001")
public class SnappyCacheManager
extends CacheManager {
    private final int sessionId;

    public void cacheQuery(Dataset<?> query, Option<String> tableName, StorageLevel storageLevel) {
        super.cacheQuery(query, tableName, storageLevel);
        SnappySession$.MODULE$.clearSessionCache(this.sessionId);
    }

    public boolean uncacheQuery(Dataset<?> query, boolean blocking) {
        boolean bl;
        if (super.uncacheQuery(query, blocking)) {
            SnappySession$.MODULE$.clearSessionCache(this.sessionId);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public void clearCache() {
        super.clearCache();
        SnappySession$.MODULE$.clearSessionCache(this.sessionId);
    }

    public void invalidateCache(LogicalPlan plan) {
        super.invalidateCache(plan);
        SnappySession$.MODULE$.clearSessionCache(this.sessionId);
    }

    public void invalidateCachedPath(SparkSession sparkSession, String resourcePath) {
        super.invalidateCachedPath(sparkSession, resourcePath);
        SnappySession$.MODULE$.clearSessionCache(this.sessionId);
    }

    public SnappyCacheManager(int sessionId) {
        this.sessionId = sessionId;
    }
}

