/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.row;

import io.snappydata.Constant$;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.jdbc.JdbcType;
import org.apache.spark.sql.row.GemFireXDClientDialect$;
import org.apache.spark.sql.row.GemFireXDDialect$;
import org.apache.spark.sql.sources.JdbcExtendedDialect;
import org.apache.spark.sql.sources.JdbcExtendedUtils$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00055a!B\u0001\u0003\u0003\u0003i!\u0001F$f[\u001aK'/\u001a-E\u0005\u0006\u001cX\rR5bY\u0016\u001cGO\u0003\u0002\u0004\t\u0005\u0019!o\\<\u000b\u0005\u00151\u0011aA:rY*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001q\u0001CA\b\u0013\u001b\u0005\u0001\"BA\t\u0005\u0003\u001d\u0019x.\u001e:dKNL!a\u0005\t\u0003')#'mY#yi\u0016tG-\u001a3ES\u0006dWm\u0019;\t\u000bU\u0001A\u0011\u0001\f\u0002\rqJg.\u001b;?)\u00059\u0002C\u0001\r\u0001\u001b\u0005\u0011\u0001\"\u0002\u000e\u0001\t\u0003Y\u0012\u0001B5oSR$\u0012\u0001\b\t\u0003;\u0001j\u0011A\b\u0006\u0002?\u0005)1oY1mC&\u0011\u0011E\b\u0002\u0005+:LG\u000fC\u0003$\u0001\u0011\u0005C%A\bhKR\u001c\u0015\r^1msN$H+\u001f9f)\u0015)cf\r\u001f?!\rib\u0005K\u0005\u0003Oy\u0011aa\u00149uS>t\u0007CA\u0015-\u001b\u0005Q#BA\u0016\u0005\u0003\u0015!\u0018\u0010]3t\u0013\ti#F\u0001\u0005ECR\fG+\u001f9f\u0011\u0015y#\u00051\u00011\u0003\u001d\u0019\u0018\u000f\u001c+za\u0016\u0004\"!H\u0019\n\u0005Ir\"aA%oi\")AG\ta\u0001k\u0005AA/\u001f9f\u001d\u0006lW\r\u0005\u00027s9\u0011QdN\u0005\u0003qy\ta\u0001\u0015:fI\u00164\u0017B\u0001\u001e<\u0005\u0019\u0019FO]5oO*\u0011\u0001H\b\u0005\u0006{\t\u0002\r\u0001M\u0001\u0005g&TX\rC\u0003@E\u0001\u0007\u0001)\u0001\u0002nIB\u0011\u0011&Q\u0005\u0003\u0005*\u0012q\"T3uC\u0012\fG/\u0019\"vS2$WM\u001d\u0005\u0006\t\u0002!\t%R\u0001\fO\u0016$(\n\u0012\"D)f\u0004X\r\u0006\u0002G\u001bB\u0019QDJ$\u0011\u0005![U\"A%\u000b\u0005)#\u0011\u0001\u00026eE\u000eL!\u0001T%\u0003\u0011)#'m\u0019+za\u0016DQAT\"A\u0002!\n!\u0001\u001a;\t\u000b\u0011\u0003A\u0011\t)\u0015\u0007\u0019\u000b&\u000bC\u0003O\u001f\u0002\u0007\u0001\u0006C\u0003@\u001f\u0002\u00071\u000b\u0005\u0002*)&\u0011QK\u000b\u0002\t\u001b\u0016$\u0018\rZ1uC\")q\u000b\u0001C!1\u0006\u0019r-\u001a;UC\ndW-\u0012=jgR\u001c\u0018+^3ssR\u0011Q'\u0017\u0005\u00065Z\u0003\r!N\u0001\u0006i\u0006\u0014G.\u001a\u0005\u00069\u0002!\t%X\u0001\rGJ,\u0017\r^3TG\",W.\u0019\u000b\u00049y\u0003\u0007\"B0\\\u0001\u0004)\u0014AC:dQ\u0016l\u0017MT1nK\")\u0011m\u0017a\u0001E\u0006!1m\u001c8o!\t\u0019w-D\u0001e\u0015\t)QMC\u0001g\u0003\u0011Q\u0017M^1\n\u0005!$'AC\"p]:,7\r^5p]\")!\u000e\u0001C!W\u0006IAM]8q)\u0006\u0014G.\u001a\u000b\u000691tw.\u001e\u0005\u0006[&\u0004\r!N\u0001\ni\u0006\u0014G.\u001a(b[\u0016DQ!Y5A\u0002\tDQ\u0001]5A\u0002E\fqaY8oi\u0016DH\u000f\u0005\u0002sg6\tA!\u0003\u0002u\t\tQ1+\u0015'D_:$X\r\u001f;\t\u000bYL\u0007\u0019A<\u0002\u0011%4W\t_5tiN\u0004\"!\b=\n\u0005et\"a\u0002\"p_2,\u0017M\u001c\u0005\u0006w\u0002!\t\u0005`\u0001\u0010S:LG/[1mSj,G+\u00192mKR)A$ @\u0002\u0002!)QN\u001fa\u0001k!)qP\u001fa\u0001o\u0006i1-Y:f'\u0016t7/\u001b;jm\u0016DQ!\u0019>A\u0002\tDq!!\u0002\u0001\t\u0003\n9!\u0001\u000bhKR\u0004\u0016M\u001d;ji&|gNQ=DY\u0006,8/\u001a\u000b\u0004k\u0005%\u0001bBA\u0006\u0003\u0007\u0001\r!N\u0001\u0004G>d\u0007")
public abstract class GemFireXDBaseDialect
extends JdbcExtendedDialect {
    public void init() {
        ((Object)((Object)GemFireXDDialect$.MODULE$)).getClass();
        ((Object)((Object)GemFireXDClientDialect$.MODULE$)).getClass();
    }

    public Option<DataType> getCatalystType(int sqlType, String typeName, int size, MetadataBuilder md) {
        Object object;
        if (sqlType == 6 && typeName.equalsIgnoreCase("float")) {
            object = new Some((Object)DoubleType$.MODULE$);
        } else if (sqlType == 7 && typeName.equalsIgnoreCase("real")) {
            object = new Some((Object)FloatType$.MODULE$);
        } else if (sqlType == 12 && size > 0 && typeName.equalsIgnoreCase("varchar")) {
            md.putLong(Constant$.MODULE$.CHAR_TYPE_SIZE_PROP(), (long)size);
            md.putString(Constant$.MODULE$.CHAR_TYPE_BASE_PROP(), "VARCHAR");
            object = new Some((Object)StringType$.MODULE$);
        } else if (sqlType == 1 && size > 0 && typeName.equalsIgnoreCase("char")) {
            md.putLong(Constant$.MODULE$.CHAR_TYPE_SIZE_PROP(), (long)size);
            md.putString(Constant$.MODULE$.CHAR_TYPE_BASE_PROP(), "CHAR");
            object = new Some((Object)StringType$.MODULE$);
        } else {
            object = sqlType == -7 && size > 1 && typeName.equalsIgnoreCase("bit") ? new Some((Object)BinaryType$.MODULE$) : None$.MODULE$;
        }
        return object;
    }

    public Option<JdbcType> getJDBCType(DataType dt) {
        Object object;
        DataType dataType = dt;
        if (StringType$.MODULE$.equals(dataType)) {
            object = new Some((Object)new JdbcType("CLOB", 2005));
        } else if (BinaryType$.MODULE$.equals(dataType)) {
            object = new Some((Object)new JdbcType("BLOB", 2004));
        } else if (BooleanType$.MODULE$.equals(dataType)) {
            object = new Some((Object)new JdbcType("BOOLEAN", 16));
        } else if (ByteType$.MODULE$.equals(dataType)) {
            object = new Some((Object)new JdbcType("SMALLINT", 4));
        } else if (ShortType$.MODULE$.equals(dataType)) {
            object = new Some((Object)new JdbcType("SMALLINT", 4));
        } else if (dataType instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)dataType;
            object = new Some((Object)new JdbcType(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DECIMAL(", ",", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)decimalType.precision()), BoxesRunTime.boxToInteger((int)decimalType.scale())})), 3));
        } else {
            boolean bl = dataType instanceof ArrayType ? true : (dataType instanceof MapType ? true : dataType instanceof StructType);
            object = bl ? new Some((Object)new JdbcType("BLOB", 2004)) : None$.MODULE$;
        }
        return object;
    }

    @Override
    public Option<JdbcType> getJDBCType(DataType dt, Metadata md) {
        Some some;
        DataType dataType = dt;
        if (StringType$.MODULE$.equals(dataType)) {
            Some some2;
            if (md.contains(Constant$.MODULE$.CHAR_TYPE_SIZE_PROP()) && md.contains(Constant$.MODULE$.CHAR_TYPE_BASE_PROP())) {
                String string = md.getString(Constant$.MODULE$.CHAR_TYPE_BASE_PROP());
                Some some3 = "CHAR".equals(string) ? new Some((Object)new JdbcType(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CHAR(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)md.getLong(Constant$.MODULE$.CHAR_TYPE_SIZE_PROP()))})), 1)) : ("VARCHAR".equals(string) ? new Some((Object)new JdbcType(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"VARCHAR(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)md.getLong(Constant$.MODULE$.CHAR_TYPE_SIZE_PROP()))})), 12)) : new Some((Object)new JdbcType("CLOB", 2005)));
                some2 = some3;
            } else {
                some2 = new Some((Object)new JdbcType("CLOB", 2005));
            }
            some = some2;
        } else {
            some = this.getJDBCType(dt);
        }
        return some;
    }

    public String getTableExistsQuery(String table) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT 1 FROM ", " FETCH FIRST ROW ONLY"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{table}));
    }

    @Override
    public void createSchema(String schemaName, Connection conn) {
        JdbcExtendedUtils$.MODULE$.executeUpdate(new StringBuilder().append((Object)"CREATE SCHEMA ").append((Object)schemaName).toString(), conn);
    }

    @Override
    public void dropTable(String tableName, Connection conn, SQLContext context2, boolean ifExists) {
        if (ifExists) {
            JdbcExtendedUtils$.MODULE$.executeUpdate(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DROP TABLE IF EXISTS ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})), conn);
        } else {
            JdbcExtendedUtils$.MODULE$.executeUpdate(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DROP TABLE ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})), conn);
        }
    }

    @Override
    public void initializeTable(String tableName, boolean caseSensitive, Connection conn) {
        Tuple2 tuple2;
        int dotIndex = tableName.indexOf(46);
        Tuple2 tuple22 = tuple2 = dotIndex > 0 ? new Tuple2((Object)tableName.substring(0, dotIndex), (Object)tableName.substring(dotIndex + 1)) : new Tuple2((Object)Constant$.MODULE$.DEFAULT_SCHEMA(), (Object)tableName);
        if (tuple2 != null) {
            Tuple2 tuple23;
            String schema = (String)tuple2._1();
            String table = (String)tuple2._2();
            Tuple2 tuple24 = tuple23 = new Tuple2((Object)schema, (Object)table);
            String schema2 = (String)tuple24._1();
            String table2 = (String)tuple24._2();
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(new StringBuilder().append((Object)"select datapolicy from sys.systables where ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tableName='", "' and tableschemaname='", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{table2, schema2}))).toString());
            String result = rs.next() ? rs.getString(1) : null;
            rs.close();
            stmt.close();
            if ("PARTITION".equalsIgnoreCase(result) || "PERSISTENT_PARTITION".equalsIgnoreCase(result)) {
                JdbcExtendedUtils$.MODULE$.executeUpdate(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"call sys.CREATE_ALL_BUCKETS('", "')"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})), conn);
            }
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    @Override
    public String getPartitionByClause(String col) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"partition by column(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{col}));
    }
}

