/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.sources;

import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.sources.CastDouble;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.NumericType;
import org.apache.spark.sql.types.ShortType$;
import scala.MatchError;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.math.Numeric;
import scala.runtime.BoxesRunTime;
import scala.sys.package$;

public abstract class CastDouble$class {
    public static final void init(CastDouble $this) {
        DataType dataType;
        block13: {
            Numeric numeric;
            int n;
            block6: {
                block12: {
                    block11: {
                        block10: {
                            block9: {
                                block8: {
                                    block7: {
                                        block5: {
                                            DataType columnType = $this.doubleColumnType();
                                            dataType = columnType;
                                            if (!IntegerType$.MODULE$.equals(dataType)) break block5;
                                            n = 0;
                                            break block6;
                                        }
                                        if (!DoubleType$.MODULE$.equals(dataType)) break block7;
                                        n = 1;
                                        break block6;
                                    }
                                    if (!LongType$.MODULE$.equals(dataType)) break block8;
                                    n = 2;
                                    break block6;
                                }
                                if (!FloatType$.MODULE$.equals(dataType)) break block9;
                                n = 3;
                                break block6;
                            }
                            if (!ShortType$.MODULE$.equals(dataType)) break block10;
                            n = 4;
                            break block6;
                        }
                        if (!ByteType$.MODULE$.equals(dataType)) break block11;
                        n = 5;
                        break block6;
                    }
                    if (!(dataType instanceof DecimalType)) break block12;
                    n = 6;
                    break block6;
                }
                if (!(dataType instanceof NumericType)) break block13;
                n = 7;
            }
            $this.castType_$eq(n);
            DataType dataType2 = $this.doubleColumnType();
            if (dataType2 instanceof NumericType) {
                NumericType numericType = (NumericType)dataType2;
                numeric = numericType.numeric();
            } else {
                numeric = null;
            }
            $this.numericCast_$eq(numeric);
            return;
        }
        throw package$.MODULE$.error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Type ", " does not support cast to double"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dataType})));
    }

    public static final double toDouble(CastDouble $this, Row row, int ordinal, double d) {
        double d2;
        int n = $this.castType();
        switch (n) {
            default: {
                throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
            }
            case 7: {
                Object v = row.get(ordinal);
                if (v == null) {
                    d2 = d;
                    break;
                }
                d2 = $this.numericCast().toDouble(v);
                break;
            }
            case 6: {
                Object v = row.get(ordinal);
                if (v == null) {
                    d2 = d;
                    break;
                }
                d2 = ((Decimal)v).toDouble();
                break;
            }
            case 5: {
                if (row.isNullAt(ordinal)) {
                    d2 = d;
                    break;
                }
                d2 = row.getByte(ordinal);
                break;
            }
            case 4: {
                if (row.isNullAt(ordinal)) {
                    d2 = d;
                    break;
                }
                d2 = row.getShort(ordinal);
                break;
            }
            case 3: {
                if (row.isNullAt(ordinal)) {
                    d2 = d;
                    break;
                }
                d2 = row.getFloat(ordinal);
                break;
            }
            case 2: {
                if (row.isNullAt(ordinal)) {
                    d2 = d;
                    break;
                }
                d2 = row.getLong(ordinal);
                break;
            }
            case 1: {
                if (row.isNullAt(ordinal)) {
                    d2 = d;
                    break;
                }
                d2 = row.getDouble(ordinal);
                break;
            }
            case 0: {
                d2 = row.isNullAt(ordinal) ? d : (double)row.getInt(ordinal);
            }
        }
        return d2;
    }

    public static final double toDouble(CastDouble $this, InternalRow row, int ordinal, double d) {
        double d2;
        int n = $this.castType();
        switch (n) {
            default: {
                throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
            }
            case 7: {
                Object v = row.get(ordinal, $this.doubleColumnType());
                if (v == null) {
                    d2 = d;
                    break;
                }
                d2 = $this.numericCast().toDouble(v);
                break;
            }
            case 6: {
                Object v = row.get(ordinal, $this.doubleColumnType());
                if (v == null) {
                    d2 = d;
                    break;
                }
                d2 = ((Decimal)v).toDouble();
                break;
            }
            case 5: {
                if (row.isNullAt(ordinal)) {
                    d2 = d;
                    break;
                }
                d2 = row.getByte(ordinal);
                break;
            }
            case 4: {
                if (row.isNullAt(ordinal)) {
                    d2 = d;
                    break;
                }
                d2 = row.getShort(ordinal);
                break;
            }
            case 3: {
                if (row.isNullAt(ordinal)) {
                    d2 = d;
                    break;
                }
                d2 = row.getFloat(ordinal);
                break;
            }
            case 2: {
                if (row.isNullAt(ordinal)) {
                    d2 = d;
                    break;
                }
                d2 = row.getLong(ordinal);
                break;
            }
            case 1: {
                if (row.isNullAt(ordinal)) {
                    d2 = d;
                    break;
                }
                d2 = row.getDouble(ordinal);
                break;
            }
            case 0: {
                d2 = row.isNullAt(ordinal) ? d : (double)row.getInt(ordinal);
            }
        }
        return d2;
    }

    public static final double toDouble(CastDouble $this, Object v) {
        double d;
        int n = $this.castType();
        switch (n) {
            default: {
                throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
            }
            case 7: {
                d = $this.numericCast().toDouble(v);
                break;
            }
            case 6: {
                d = ((Decimal)v).toDouble();
                break;
            }
            case 5: {
                d = BoxesRunTime.unboxToByte((Object)v);
                break;
            }
            case 4: {
                d = BoxesRunTime.unboxToShort((Object)v);
                break;
            }
            case 3: {
                d = BoxesRunTime.unboxToFloat((Object)v);
                break;
            }
            case 2: {
                d = BoxesRunTime.unboxToLong((Object)v);
                break;
            }
            case 1: {
                d = BoxesRunTime.unboxToDouble((Object)v);
                break;
            }
            case 0: {
                d = BoxesRunTime.unboxToInt((Object)v);
            }
        }
        return d;
    }

    public static void $init$(CastDouble $this) {
    }
}

