/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.sources;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.spark.Logging;
import org.apache.spark.Logging$class;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SnappySession;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.analysis.UnresolvedRelation;
import org.apache.spark.sql.catalyst.analysis.UnresolvedRelation$;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder;
import org.apache.spark.sql.catalyst.encoders.RowEncoder$;
import org.apache.spark.sql.catalyst.plans.logical.InsertIntoTable;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.datasources.CaseInsensitiveMap;
import org.apache.spark.sql.execution.datasources.DataSource;
import org.apache.spark.sql.execution.datasources.DataSource$;
import org.apache.spark.sql.internal.SnappySessionState;
import org.apache.spark.sql.jdbc.JdbcDialect;
import org.apache.spark.sql.jdbc.JdbcType;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.sources.ExternalSchemaRelationProvider;
import org.apache.spark.sql.sources.JdbcExtendedDialect;
import org.apache.spark.sql.sources.PutIntoTable;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.TraitSetter;
import scala.util.control.NonFatal$;

public final class JdbcExtendedUtils$
implements Logging {
    public static final JdbcExtendedUtils$ MODULE$;
    private final String DBTABLE_PROPERTY;
    private final String SCHEMA_PROPERTY;
    private final String ALLOW_EXISTING_PROPERTY;
    private final String BASETABLE_PROPERTY;
    private final String TABLETYPE_PROPERTY;
    private transient Logger org$apache$spark$Logging$$log_;
    private transient int org$apache$spark$Logging$$levelFlags;

    static {
        new JdbcExtendedUtils$();
    }

    @Override
    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    @Override
    @TraitSetter
    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    @Override
    public int org$apache$spark$Logging$$levelFlags() {
        return this.org$apache$spark$Logging$$levelFlags;
    }

    @Override
    public void org$apache$spark$Logging$$levelFlags_$eq(int x$1) {
        this.org$apache$spark$Logging$$levelFlags = x$1;
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public Logger log() {
        return Logging$class.log(this);
    }

    @Override
    public final boolean isInfoEnabled() {
        return Logging$class.isInfoEnabled(this);
    }

    @Override
    public final boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public final boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging$class.initializeLogIfNecessary(this, isInterpreter);
    }

    public String DBTABLE_PROPERTY() {
        return this.DBTABLE_PROPERTY;
    }

    public String SCHEMA_PROPERTY() {
        return this.SCHEMA_PROPERTY;
    }

    public String ALLOW_EXISTING_PROPERTY() {
        return this.ALLOW_EXISTING_PROPERTY;
    }

    public String BASETABLE_PROPERTY() {
        return this.BASETABLE_PROPERTY;
    }

    public String TABLETYPE_PROPERTY() {
        return this.TABLETYPE_PROPERTY;
    }

    /*
     * WARNING - void declaration
     */
    public void executeUpdate(String sql2, Connection conn) {
        Statement stmt = conn.createStatement();
        try {
            stmt.executeUpdate(sql2);
        }
        catch (Throwable throwable) {
            void var3_3;
            var3_3.close();
            throw throwable;
        }
        stmt.close();
    }

    public String schemaString(StructType schema, JdbcDialect dialect) {
        Object object;
        JdbcDialect jdbcDialect = dialect;
        if (jdbcDialect instanceof JdbcExtendedDialect) {
            JdbcExtendedDialect jdbcExtendedDialect = (JdbcExtendedDialect)jdbcDialect;
            object = new Serializable(jdbcExtendedDialect){
                public static final long serialVersionUID = 0L;
                private final JdbcExtendedDialect x2$1;

                public final Option<JdbcType> apply(DataType dataType, Metadata md) {
                    return this.x2$1.getJDBCType(dataType, md);
                }
                {
                    this.x2$1 = x2$1;
                }
            };
        } else {
            object = new Serializable(dialect){
                public static final long serialVersionUID = 0L;
                private final JdbcDialect dialect$1;

                public final Option<JdbcType> apply(DataType dataType, Metadata x$1) {
                    return this.dialect$1.getJDBCType(dataType);
                }
                {
                    this.dialect$1 = dialect$1;
                }
            };
        }
        Serializable jdbcType = object;
        StringBuilder sb = new StringBuilder();
        Predef$.MODULE$.refArrayOps((Object[])schema.fields()).foreach((Function1)new Serializable((Function2)jdbcType, sb){
            public static final long serialVersionUID = 0L;
            private final Function2 jdbcType$1;
            private final StringBuilder sb$1;

            public final Object apply(StructField field) {
                DataType dataType = field.dataType();
                String typeString = (String)((Option)this.jdbcType$1.apply((Object)dataType, (Object)field.metadata())).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(JdbcType x$2) {
                        return x$2.databaseTypeDefinition();
                    }
                }).getOrElse((Function0)new Serializable(this, dataType, field){
                    public static final long serialVersionUID = 0L;
                    private final DataType dataType$1;
                    private final StructField field$1;

                    public final String apply() {
                        block14: {
                            String string;
                            block3: {
                                DecimalType decimalType;
                                Option option;
                                DataType dataType;
                                block13: {
                                    block12: {
                                        block11: {
                                            block10: {
                                                block9: {
                                                    block8: {
                                                        block7: {
                                                            block6: {
                                                                block5: {
                                                                    block4: {
                                                                        block2: {
                                                                            dataType = this.dataType$1;
                                                                            if (!IntegerType$.MODULE$.equals(dataType)) break block2;
                                                                            string = "INTEGER";
                                                                            break block3;
                                                                        }
                                                                        if (!LongType$.MODULE$.equals(dataType)) break block4;
                                                                        string = "BIGINT";
                                                                        break block3;
                                                                    }
                                                                    if (!DoubleType$.MODULE$.equals(dataType)) break block5;
                                                                    string = "DOUBLE PRECISION";
                                                                    break block3;
                                                                }
                                                                if (!FloatType$.MODULE$.equals(dataType)) break block6;
                                                                string = "REAL";
                                                                break block3;
                                                            }
                                                            if (!ShortType$.MODULE$.equals(dataType)) break block7;
                                                            string = "INTEGER";
                                                            break block3;
                                                        }
                                                        if (!ByteType$.MODULE$.equals(dataType)) break block8;
                                                        string = "BYTE";
                                                        break block3;
                                                    }
                                                    if (!BooleanType$.MODULE$.equals(dataType)) break block9;
                                                    string = "BIT(1)";
                                                    break block3;
                                                }
                                                if (!StringType$.MODULE$.equals(dataType)) break block10;
                                                string = "TEXT";
                                                break block3;
                                            }
                                            if (!BinaryType$.MODULE$.equals(dataType)) break block11;
                                            string = "BLOB";
                                            break block3;
                                        }
                                        if (!TimestampType$.MODULE$.equals(dataType)) break block12;
                                        string = "TIMESTAMP";
                                        break block3;
                                    }
                                    if (!DateType$.MODULE$.equals(dataType)) break block13;
                                    string = "DATE";
                                    break block3;
                                }
                                if (!(dataType instanceof DecimalType) || (option = DecimalType.Fixed$.MODULE$.unapply(decimalType = (DecimalType)dataType)).isEmpty()) break block14;
                                int precision = ((Tuple2)option.get())._1$mcI$sp();
                                int scale = ((Tuple2)option.get())._2$mcI$sp();
                                string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DECIMAL(", ",", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)precision), BoxesRunTime.boxToInteger((int)scale)}));
                            }
                            return string;
                        }
                        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Don't know how to save ", " to JDBC"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.field$1})));
                    }
                    {
                        this.dataType$1 = dataType$1;
                        this.field$1 = field$1;
                    }
                });
                this.sb$1.append(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{", ", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{field.name(), typeString})));
                return field.nullable() ? BoxedUnit.UNIT : this.sb$1.append(" NOT NULL");
            }
            {
                this.jdbcType$1 = jdbcType$1;
                this.sb$1 = sb$1;
            }
        });
        return sb.length() < 2 ? "" : "(".concat(sb.substring(2)).concat(")");
    }

    public boolean tableExistsInMetaData(String table, Connection conn, JdbcDialect dialect) {
        boolean bl;
        int dotIndex = table.indexOf(46);
        String schemaName = dotIndex > 0 ? table.substring(0, dotIndex) : conn.getSchema();
        String tableName = dotIndex > 0 ? table.substring(dotIndex + 1) : table;
        try {
            ResultSet rs = conn.getMetaData().getTables(null, schemaName, tableName, null);
            bl = rs.next();
        }
        catch (SQLException sQLException) {
            bl = false;
        }
        return bl;
    }

    public void createSchema(String schemaName, Connection conn, JdbcDialect dialect) {
        JdbcDialect jdbcDialect = dialect;
        if (jdbcDialect instanceof JdbcExtendedDialect) {
            JdbcExtendedDialect jdbcExtendedDialect = (JdbcExtendedDialect)jdbcDialect;
            jdbcExtendedDialect.createSchema(schemaName, conn);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public boolean tableExists(String table, Connection conn, JdbcDialect dialect, SQLContext context2) {
        boolean bl;
        Object object = new Object();
        try {
            boolean bl2;
            JdbcDialect jdbcDialect = dialect;
            if (jdbcDialect instanceof JdbcExtendedDialect) {
                JdbcExtendedDialect jdbcExtendedDialect = (JdbcExtendedDialect)jdbcDialect;
                bl2 = jdbcExtendedDialect.tableExists(table, conn, context2);
            } else {
                boolean bl3;
                try {
                    bl3 = this.tableExistsInMetaData(table, conn, dialect);
                }
                catch (Throwable throwable) {
                    boolean bl4;
                    Throwable throwable2 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (option.isEmpty()) {
                        throw throwable;
                    }
                    Statement stmt = conn.createStatement();
                    String[] testQueries = (String[])((Object[])new String[]{new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT 1 FROM ", " LIMIT 1"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{table})), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT 1 FROM ", " FETCH FIRST ROW ONLY"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{table})), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT COUNT(1) FROM ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{table}))});
                    Predef$.MODULE$.refArrayOps((Object[])testQueries).foreach((Function1)new Serializable(stmt, object){
                        public static final long serialVersionUID = 0L;
                        private final Statement stmt$1;
                        private final Object nonLocalReturnKey1$1;

                        public final void apply(String q) {
                            try {
                                ResultSet rs = this.stmt$1.executeQuery(q);
                                rs.next();
                                rs.close();
                                this.stmt$1.close();
                                throw new NonLocalReturnControl.mcZ.sp(this.nonLocalReturnKey1$1, true);
                            }
                            catch (Throwable throwable) {
                                Throwable throwable2 = throwable;
                                Option option = NonFatal$.MODULE$.unapply(throwable2);
                                if (option.isEmpty()) {
                                    throw throwable;
                                }
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                return;
                            }
                        }
                        {
                            this.stmt$1 = stmt$1;
                            this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                        }
                    });
                    bl3 = bl4 = false;
                }
                bl2 = bl3;
            }
            bl = bl2;
        }
        catch (NonLocalReturnControl nonLocalReturnControl) {
            if (nonLocalReturnControl.key() == object) {
                bl = nonLocalReturnControl.value$mcZ$sp();
            }
            throw nonLocalReturnControl;
        }
        return bl;
    }

    public void dropTable(Connection conn, String tableName, JdbcDialect dialect, SQLContext context2, boolean ifExists) {
        JdbcDialect jdbcDialect = dialect;
        if (jdbcDialect instanceof JdbcExtendedDialect) {
            JdbcExtendedDialect jdbcExtendedDialect = (JdbcExtendedDialect)jdbcDialect;
            jdbcExtendedDialect.dropTable(tableName, conn, context2, ifExists);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit;
            if (ifExists && !this.tableExists(tableName, conn, dialect, context2)) {
                boxedUnit = BoxedUnit.UNIT;
            } else {
                this.executeUpdate(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DROP TABLE ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})), conn);
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        }
    }

    public void truncateTable(Connection conn, String tableName, JdbcDialect dialect) {
        JdbcDialect jdbcDialect = dialect;
        if (jdbcDialect instanceof JdbcExtendedDialect) {
            JdbcExtendedDialect jdbcExtendedDialect = (JdbcExtendedDialect)jdbcDialect;
            this.executeUpdate(jdbcExtendedDialect.truncateTable(tableName), conn);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            this.executeUpdate(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TRUNCATE TABLE ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})), conn);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    /*
     * WARNING - void declaration
     */
    public BaseRelation externalResolvedDataSource(SnappySession snappySession, String schemaString2, String provider, SaveMode mode, Map<String, String> options, Option<LogicalPlan> data) {
        void var8_8;
        DataSource dataSource = new DataSource((SparkSession)snappySession, provider, DataSource$.MODULE$.apply$default$3(), DataSource$.MODULE$.apply$default$4(), DataSource$.MODULE$.apply$default$5(), DataSource$.MODULE$.apply$default$6(), DataSource$.MODULE$.apply$default$7());
        Class clazz = dataSource.providingClass();
        Object t = clazz.newInstance();
        if (t instanceof ExternalSchemaRelationProvider) {
            BaseRelation baseRelation;
            Object t2 = t;
            BaseRelation relation = baseRelation = ((ExternalSchemaRelationProvider)t2).createRelation(snappySession.snappyContext(), mode, (Map<String, String>)new CaseInsensitiveMap(options.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.SCHEMA_PROPERTY()), (Object)schemaString2)).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"EXTERNAL_DATASOURCE"), (Object)"true"))), schemaString2, data);
            return relation;
        }
        throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is not an ExternalSchemaRelationProvider."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var8_8.getCanonicalName()})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Option<LogicalPlan> externalResolvedDataSource$default$6() {
        return None$.MODULE$;
    }

    public String getInsertOrPutString(String table, StructType rddSchema, boolean upsert) {
        StringBuilder sql2 = new StringBuilder();
        StringBuilder stringBuilder = upsert ? sql2.append(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"PUT INTO ", " ("})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{table}))) : sql2.append(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"INSERT INTO ", " ("})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{table})));
        IntRef fieldsLeft = IntRef.create((int)rddSchema.fields().length);
        Predef$.MODULE$.refArrayOps((Object[])rddSchema.fields()).foreach((Function1)new Serializable(sql2, fieldsLeft){
            public static final long serialVersionUID = 0L;
            private final StringBuilder sql$1;
            private final IntRef fieldsLeft$1;

            public final void apply(StructField field) {
                this.sql$1.append(field.name());
                StringBuilder stringBuilder = this.fieldsLeft$1.elem > 1 ? this.sql$1.append(',') : this.sql$1.append(')');
                --this.fieldsLeft$1.elem;
            }
            {
                this.sql$1 = sql$1;
                this.fieldsLeft$1 = fieldsLeft$1;
            }
        });
        sql2.append(" VALUES (");
        fieldsLeft.elem = rddSchema.fields().length;
        while (fieldsLeft.elem > 0) {
            sql2.append('?');
            StringBuilder stringBuilder2 = fieldsLeft.elem > 1 ? sql2.append(',') : sql2.append(')');
            --fieldsLeft.elem;
        }
        return sql2.toString();
    }

    public int bulkInsertOrPut(Seq<Row> rows, SparkSession sparkSession, StructType schema, String resolvedName, boolean upsert) {
        SnappySession session = (SnappySession)sparkSession;
        SnappySessionState sessionState = session.sessionState();
        TableIdentifier tableIdent = sessionState.sqlParser().parseTableIdentifier(resolvedName);
        ExpressionEncoder encoder = RowEncoder$.MODULE$.apply(schema);
        Dataset ds = session.internalCreateDataFrame(session.sparkContext().parallelize((Seq)rows.map((Function1)new Serializable(encoder){
            public static final long serialVersionUID = 0L;
            private final ExpressionEncoder encoder$1;

            public final InternalRow apply(Row t) {
                return this.encoder$1.toRow((Object)t);
            }
            {
                this.encoder$1 = encoder$1;
            }
        }, Seq$.MODULE$.canBuildFrom()), session.sparkContext().parallelize$default$2(), ClassTag$.MODULE$.apply(InternalRow.class)), schema);
        PutIntoTable plan = upsert ? new PutIntoTable((LogicalPlan)new UnresolvedRelation(tableIdent, UnresolvedRelation$.MODULE$.apply$default$2()), ds.logicalPlan()) : new InsertIntoTable((LogicalPlan)new UnresolvedRelation(tableIdent, UnresolvedRelation$.MODULE$.apply$default$2()), Predef$.MODULE$.Map().empty(), ds.logicalPlan(), false, false);
        return BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.refArrayOps((Object[])session.sessionState().executePlan(plan).executedPlan().executeCollect()).foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(int x$3, InternalRow x$4) {
                return x$3 + x$4.getInt(0);
            }
        }));
    }

    private JdbcExtendedUtils$() {
        MODULE$ = this;
        Logging$class.$init$(this);
        this.DBTABLE_PROPERTY = "dbtable";
        this.SCHEMA_PROPERTY = "schemaddl";
        this.ALLOW_EXISTING_PROPERTY = "allowexisting";
        this.BASETABLE_PROPERTY = "basetable";
        this.TABLETYPE_PROPERTY = "EXTERNAL_SNAPPY";
    }
}

