/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.sources;

import org.apache.spark.Partition;
import org.apache.spark.SparkContext;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Dataset$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SnappySession;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.columnar.ExternalStoreUtils$;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCPartitioningInfo;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCRelation$;
import org.apache.spark.sql.hive.SnappyStoreHiveCatalog;
import org.apache.spark.sql.hive.SnappyStoreHiveCatalog$;
import org.apache.spark.sql.jdbc.JdbcDialect;
import org.apache.spark.sql.jdbc.JdbcDialects$;
import org.apache.spark.sql.row.DefaultSource;
import org.apache.spark.sql.row.JDBCMutableRelation;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.sources.ConnectionProperties;
import org.apache.spark.sql.sources.CreatableRelationProvider;
import org.apache.spark.sql.sources.ExternalSchemaRelationProvider;
import org.apache.spark.sql.sources.JdbcExtendedUtils$;
import org.apache.spark.sql.sources.RelationProvider;
import org.apache.spark.sql.sources.SchemaRelationProvider;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashMap;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001u4Q!\u0001\u0002\u0002\u00025\u0011q#T;uC\ndWMU3mCRLwN\u001c)s_ZLG-\u001a:\u000b\u0005\r!\u0011aB:pkJ\u001cWm\u001d\u0006\u0003\u000b\u0019\t1a]9m\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7\u0001A\n\u0007\u00019!\u0002d\u0007\u0010\u0011\u0005=\u0011R\"\u0001\t\u000b\u0003E\tQa]2bY\u0006L!a\u0005\t\u0003\r\u0005s\u0017PU3g!\t)b#D\u0001\u0003\u0013\t9\"A\u0001\u0010FqR,'O\\1m'\u000eDW-\\1SK2\fG/[8o!J|g/\u001b3feB\u0011Q#G\u0005\u00035\t\u0011acU2iK6\f'+\u001a7bi&|g\u000e\u0015:pm&$WM\u001d\t\u0003+qI!!\b\u0002\u0003!I+G.\u0019;j_:\u0004&o\u001c<jI\u0016\u0014\bCA\u000b \u0013\t\u0001#AA\rDe\u0016\fG/\u00192mKJ+G.\u0019;j_:\u0004&o\u001c<jI\u0016\u0014\b\"\u0002\u0012\u0001\t\u0003\u0019\u0013A\u0002\u001fj]&$h\bF\u0001%!\t)\u0002\u0001C\u0003'\u0001\u0011\u0005s%\u0001\bde\u0016\fG/\u001a*fY\u0006$\u0018n\u001c8\u0015\r!rC'O#H!\tIC&D\u0001+\u0015\tYC!A\u0002s_^L!!\f\u0016\u0003')#%iQ'vi\u0006\u0014G.\u001a*fY\u0006$\u0018n\u001c8\t\u000b=*\u0003\u0019\u0001\u0019\u0002\u0015M\fHnQ8oi\u0016DH\u000f\u0005\u00022e5\tA!\u0003\u00024\t\tQ1+\u0015'D_:$X\r\u001f;\t\u000bU*\u0003\u0019\u0001\u001c\u0002\t5|G-\u001a\t\u0003c]J!\u0001\u000f\u0003\u0003\u0011M\u000bg/Z'pI\u0016DQAO\u0013A\u0002m\nqa\u001c9uS>t7\u000f\u0005\u0003=\u007f\t\u0013eBA\b>\u0013\tq\u0004#\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u0001\u0006\u00131!T1q\u0015\tq\u0004\u0003\u0005\u0002=\u0007&\u0011A)\u0011\u0002\u0007'R\u0014\u0018N\\4\t\u000b\u0019+\u0003\u0019\u0001\"\u0002\rM\u001c\u0007.Z7b\u0011\u0015AU\u00051\u0001J\u0003\u0011!\u0017\r^1\u0011\u0007=QE*\u0003\u0002L!\t1q\n\u001d;j_:\u0004\"!\u0014+\u000e\u00039S!a\u0014)\u0002\u000f1|w-[2bY*\u0011\u0011KU\u0001\u0006a2\fgn\u001d\u0006\u0003'\u0012\t\u0001bY1uC2L8\u000f^\u0005\u0003+:\u00131\u0002T8hS\u000e\fG\u000e\u00157b]\")a\u0005\u0001C!/R!\u0001\u0006W-[\u0011\u0015yc\u000b1\u00011\u0011\u0015Qd\u000b1\u0001<\u0011\u00151e\u000b1\u0001\\!\tav,D\u0001^\u0015\tqF!A\u0003usB,7/\u0003\u0002a;\nQ1\u000b\u001e:vGR$\u0016\u0010]3\t\u000b\u0019\u0002A\u0011\t2\u0015\u0007!\u001aG\rC\u00030C\u0002\u0007\u0001\u0007C\u0003;C\u0002\u00071\bC\u0003'\u0001\u0011\u0005c\rF\u0003)O\"L'\u000eC\u00030K\u0002\u0007\u0001\u0007C\u00036K\u0002\u0007a\u0007C\u0003;K\u0002\u00071\bC\u0003IK\u0002\u00071\u000e\u0005\u0002mu:\u0011Q\u000e\u001f\b\u0003]^t!a\u001c<\u000f\u0005A,hBA9u\u001b\u0005\u0011(BA:\r\u0003\u0019a$o\\8u}%\t1\"\u0003\u0002\n\u0015%\u0011q\u0001C\u0005\u0003\u000b\u0019I!!\u001f\u0003\u0002\u000fA\f7m[1hK&\u00111\u0010 \u0002\n\t\u0006$\u0018M\u0012:b[\u0016T!!\u001f\u0003")
public abstract class MutableRelationProvider
implements ExternalSchemaRelationProvider,
SchemaRelationProvider,
RelationProvider,
CreatableRelationProvider {
    @Override
    public JDBCMutableRelation createRelation(SQLContext sqlContext, SaveMode mode, Map<String, String> options, String schema, Option<LogicalPlan> data) {
        JDBCPartitioningInfo jDBCPartitioningInfo;
        HashMap parameters = new HashMap();
        parameters.$plus$plus$eq(options);
        Option partitionColumn = parameters.remove((Object)"partitioncolumn");
        Option lowerBound = parameters.remove((Object)"lowerbound");
        Option upperBound = parameters.remove((Object)"upperbound");
        Option numPartitions = parameters.remove((Object)"numpartitions");
        String table = ExternalStoreUtils$.MODULE$.removeInternalProps((scala.collection.mutable.Map<String, String>)parameters);
        ConnectionProperties connProperties = ExternalStoreUtils$.MODULE$.validateAndGetAllProps((Option<SparkSession>)new Some((Object)sqlContext.sparkSession()), (scala.collection.mutable.Map<String, String>)parameters);
        if (partitionColumn.isEmpty()) {
            jDBCPartitioningInfo = null;
        } else {
            if (lowerBound.isEmpty() || upperBound.isEmpty() || numPartitions.isEmpty()) {
                throw new IllegalArgumentException("JDBCUpdatableRelation: incomplete partitioning specified");
            }
            jDBCPartitioningInfo = new JDBCPartitioningInfo((String)partitionColumn.get(), new StringOps(Predef$.MODULE$.augmentString((String)lowerBound.get())).toLong(), new StringOps(Predef$.MODULE$.augmentString((String)upperBound.get())).toLong(), new StringOps(Predef$.MODULE$.augmentString((String)numPartitions.get())).toInt());
        }
        JDBCPartitioningInfo partitionInfo = jDBCPartitioningInfo;
        Partition[] parts = JDBCRelation$.MODULE$.columnPartition(partitionInfo);
        String tableName = SnappyStoreHiveCatalog$.MODULE$.processTableIdentifier(table, sqlContext.conf());
        boolean success = false;
        JDBCMutableRelation relation = new JDBCMutableRelation(connProperties, tableName, this.getClass().getCanonicalName(), mode, schema, parts, options, sqlContext);
        try {
            Option<LogicalPlan> option;
            block13: {
                SnappyStoreHiveCatalog catalog;
                block12: {
                    block11: {
                        relation.tableSchema_$eq(relation.createTable(mode));
                        catalog = ((SnappySession)sqlContext.sparkSession()).sessionCatalog();
                        option = data;
                        if (!(option instanceof Some)) break block11;
                        Some some = (Some)option;
                        LogicalPlan plan = (LogicalPlan)some.x();
                        relation.insert((Dataset<Row>)Dataset$.MODULE$.ofRows(sqlContext.sparkSession(), plan), false);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block12;
                    }
                    if (!None$.MODULE$.equals(option)) break block13;
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                catalog.registerDataSourceTable(catalog.newQualifiedTableName(tableName), (Option<StructType>)None$.MODULE$, (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)), DefaultSource.class.getCanonicalName(), (Map<String, String>)((Map)options.$minus((Object)JdbcExtendedUtils$.MODULE$.SCHEMA_PROPERTY())), relation);
                success = true;
                return relation;
            }
            throw new MatchError(option);
        }
        finally {
            if (!success && !relation.tableExists()) {
                relation.destroy(true);
            }
        }
    }

    public JDBCMutableRelation createRelation(SQLContext sqlContext, Map<String, String> options, StructType schema) {
        String url = (String)options.getOrElse((Object)"url", (Function0)new Serializable(this, sqlContext){
            public static final long serialVersionUID = 0L;
            private final SQLContext sqlContext$2;

            public final String apply() {
                return ExternalStoreUtils$.MODULE$.defaultStoreURL((Option<SparkContext>)new Some((Object)this.sqlContext$2.sparkContext()));
            }
            {
                this.sqlContext$2 = sqlContext$2;
            }
        });
        JdbcDialect dialect = JdbcDialects$.MODULE$.get(url);
        String schemaString2 = JdbcExtendedUtils$.MODULE$.schemaString(schema, dialect);
        boolean allowExisting = options.get((Object)JdbcExtendedUtils$.MODULE$.ALLOW_EXISTING_PROPERTY()).exists((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$1) {
                return new StringOps(Predef$.MODULE$.augmentString(x$1)).toBoolean();
            }
        });
        SaveMode mode = allowExisting ? SaveMode.Ignore : SaveMode.ErrorIfExists;
        return this.createRelation(sqlContext, mode, (Map)options, schemaString2, (Option)None$.MODULE$);
    }

    public JDBCMutableRelation createRelation(SQLContext sqlContext, Map<String, String> options) {
        boolean allowExisting = options.get((Object)JdbcExtendedUtils$.MODULE$.ALLOW_EXISTING_PROPERTY()).exists((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$2) {
                return new StringOps(Predef$.MODULE$.augmentString(x$2)).toBoolean();
            }
        });
        SaveMode mode = allowExisting ? SaveMode.Ignore : SaveMode.ErrorIfExists;
        return this.createRelation(sqlContext, mode, (Map)options, "", (Option)None$.MODULE$);
    }

    public JDBCMutableRelation createRelation(SQLContext sqlContext, SaveMode mode, Map<String, String> options, Dataset<Row> data) {
        String url = (String)options.getOrElse((Object)"url", (Function0)new Serializable(this, sqlContext){
            public static final long serialVersionUID = 0L;
            private final SQLContext sqlContext$1;

            public final String apply() {
                return ExternalStoreUtils$.MODULE$.defaultStoreURL((Option<SparkContext>)new Some((Object)this.sqlContext$1.sparkContext()));
            }
            {
                this.sqlContext$1 = sqlContext$1;
            }
        });
        JdbcDialect dialect = JdbcDialects$.MODULE$.get(url);
        String schemaString2 = JdbcExtendedUtils$.MODULE$.schemaString(data.schema(), dialect);
        BaseRelation relation = this.createRelation(sqlContext, mode, (Map)options, schemaString2, (Option)None$.MODULE$);
        boolean success = false;
        try {
            relation.insert(data, false);
            success = true;
            return relation;
        }
        finally {
            if (!success && !relation.tableExists()) {
                SnappyStoreHiveCatalog catalog = ((SnappySession)sqlContext.sparkSession()).sessionCatalog();
                catalog.unregisterDataSourceTable(catalog.newQualifiedTableName(relation.table()), (Option<BaseRelation>)new Some((Object)relation));
                relation.destroy(true);
            }
        }
    }
}

