/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.sources;

import org.apache.spark.sql.sources.StatVarianceCounter;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.math.package$;
import scala.runtime.BoxesRunTime;

public abstract class StatVarianceCounter$class {
    public static final void initStats(StatVarianceCounter $this, long count2, double mean, double nvariance) {
        $this.count_$eq(count2);
        $this.mean_$eq(mean);
        $this.nvariance_$eq(nvariance);
    }

    public static final void merge(StatVarianceCounter $this, double value) {
        double delta = value - $this.mean();
        $this.count_$eq($this.count() + 1L);
        $this.mean_$eq($this.mean() + delta / (double)$this.count());
        $this.nvariance_$eq($this.nvariance() + delta * (value - $this.mean()));
    }

    public static final void merge(StatVarianceCounter $this, TraversableOnce values) {
        values.foreach((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StatVarianceCounter $outer;

            public final void apply(double value) {
                this.apply$mcVD$sp(value);
            }

            public void apply$mcVD$sp(double value) {
                this.$outer.merge(value);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public static final void merge(StatVarianceCounter $this, StatVarianceCounter other) {
        while (true) {
            StatVarianceCounter statVarianceCounter = other;
            StatVarianceCounter statVarianceCounter2 = $this;
            if (statVarianceCounter != null ? !statVarianceCounter.equals(statVarianceCounter2) : statVarianceCounter2 != null) break;
            other = other.copy();
        }
        $this.mergeDistinctCounter(other);
    }

    public static void mergeDistinctCounter(StatVarianceCounter $this, StatVarianceCounter other) {
        if ($this.count() == 0L) {
            $this.mean_$eq(other.mean());
            $this.nvariance_$eq(other.nvariance());
            $this.count_$eq(other.count());
        } else if (other.count() != 0L) {
            double delta = other.mean() - $this.mean();
            if (other.count() * 10L < $this.count()) {
                $this.mean_$eq($this.mean() + delta * (double)other.count() / (double)($this.count() + other.count()));
            } else if ($this.count() * 10L < other.count()) {
                $this.mean_$eq(other.mean() - delta * (double)$this.count() / (double)($this.count() + other.count()));
            } else {
                $this.mean_$eq(($this.mean() * (double)$this.count() + other.mean() * (double)other.count()) / (double)($this.count() + other.count()));
            }
            $this.nvariance_$eq($this.nvariance() + (other.nvariance() + delta * delta * (double)$this.count() * (double)other.count() / (double)($this.count() + other.count())));
            $this.count_$eq($this.count() + other.count());
        }
    }

    public static final double sum(StatVarianceCounter $this) {
        return $this.mean() * (double)$this.count();
    }

    public static final double variance(StatVarianceCounter $this) {
        return $this.count() != 0L ? $this.nvariance() / (double)$this.count() : Double.NaN;
    }

    public static final double sampleVariance(StatVarianceCounter $this) {
        return $this.count() > 1L ? $this.nvariance() / (double)($this.count() - 1L) : Double.NaN;
    }

    public static final double stdev(StatVarianceCounter $this) {
        return package$.MODULE$.sqrt($this.variance());
    }

    public static final double sampleStdev(StatVarianceCounter $this) {
        return package$.MODULE$.sqrt($this.sampleVariance());
    }

    public static String toString(StatVarianceCounter $this) {
        return new StringOps(Predef$.MODULE$.augmentString("(count: %d, mean: %f, stdev: %f)")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)$this.count()), BoxesRunTime.boxToDouble((double)$this.mean()), BoxesRunTime.boxToDouble((double)$this.stdev())}));
    }

    public static void $init$(StatVarianceCounter $this) {
        $this.count_$eq(0L);
        $this.mean_$eq(0.0);
        $this.nvariance_$eq(0.0);
    }
}

