/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.store;

import com.pivotal.gemfirexd.internal.iapi.types.SQLBit;
import com.pivotal.gemfirexd.internal.iapi.types.SQLBoolean;
import com.pivotal.gemfirexd.internal.iapi.types.SQLChar;
import com.pivotal.gemfirexd.internal.iapi.types.SQLDate;
import com.pivotal.gemfirexd.internal.iapi.types.SQLDecimal;
import com.pivotal.gemfirexd.internal.iapi.types.SQLDouble;
import com.pivotal.gemfirexd.internal.iapi.types.SQLInteger;
import com.pivotal.gemfirexd.internal.iapi.types.SQLLongint;
import com.pivotal.gemfirexd.internal.iapi.types.SQLReal;
import com.pivotal.gemfirexd.internal.iapi.types.SQLSmallint;
import com.pivotal.gemfirexd.internal.iapi.types.SQLTimestamp;
import com.pivotal.gemfirexd.internal.iapi.types.SQLTinyint;
import com.pivotal.gemfirexd.internal.shared.common.ResolverUtils;
import java.sql.Timestamp;
import java.util.Date;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.unsafe.Platform;
import org.apache.spark.unsafe.hash.Murmur3_x86_32;
import org.apache.spark.unsafe.types.CalendarInterval;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

@ScalaSignature(bytes="\u0006\u0001a3A!\u0001\u0002\u0003\u001b\t\t2\u000b^8sK\"\u000b7\u000f\u001b$v]\u000e$\u0018n\u001c8\u000b\u0005\r!\u0011!B:u_J,'BA\u0003\u0007\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u000f!\tQa\u001d9be.T!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sO\u000e\u00011C\u0001\u0001\u000f!\ty!#D\u0001\u0011\u0015\u0005\t\u0012!B:dC2\f\u0017BA\n\u0011\u0005\u0019\te.\u001f*fM\")Q\u0003\u0001C\u0001-\u00051A(\u001b8jiz\"\u0012a\u0006\t\u00031\u0001i\u0011A\u0001\u0005\u00065\u0001!\taG\u0001\u0012G>l\u0007/\u001e;f\u0007>dW/\u001c8ICNDGc\u0001\u000f IA\u0011q\"H\u0005\u0003=A\u00111!\u00138u\u0011\u0015\u0001\u0013\u00041\u0001\"\u0003\rYW-\u001f\t\u0003\u001f\tJ!a\t\t\u0003\u0007\u0005s\u0017\u0010C\u0003&3\u0001\u0007A$\u0001\u0003tK\u0016$\u0007\"B\u0014\u0001\t\u0003A\u0013aC2p[B,H/\u001a%bg\"$2\u0001H\u0015+\u0011\u0015\u0001c\u00051\u0001\"\u0011\u0015Yc\u00051\u0001\u001d\u00035qW/\u001c)beRLG/[8og\")q\u0005\u0001C\u0001[Q\u0019ADL\u001e\t\u000b=b\u0003\u0019\u0001\u0019\u0002\t=\u0014'n\u001d\t\u0004\u001fE\u001a\u0014B\u0001\u001a\u0011\u0005\u0015\t%O]1z!\t!\u0014(D\u00016\u0015\t1t'\u0001\u0003mC:<'\"\u0001\u001d\u0002\t)\fg/Y\u0005\u0003uU\u0012aa\u00142kK\u000e$\b\"B\u0016-\u0001\u0004a\u0002\"B\u001f\u0001\t\u0013q\u0014!E2p[B,H/Z*ue&tw\rS1tQR\u0019AdP#\t\u000b\u0001c\u0004\u0019A!\u0002\t\u0011\fG/\u0019\t\u0004\u001fE\u0012\u0005CA\bD\u0013\t!\u0005C\u0001\u0003DQ\u0006\u0014\b\"B\u0013=\u0001\u0004a\u0002\"B$\u0001\t\u0013A\u0015!B7jq.\u000bDC\u0001\u000fJ\u0011\u0015Qe\t1\u0001\u001d\u0003\u00051\b\"\u0002'\u0001\t\u0013i\u0015!B7jq\"\u000bDc\u0001\u000fO!\")qj\u0013a\u00019\u0005\u0011a/\r\u0005\u0006#.\u0003\r\u0001H\u0001\u0003mJBQa\u0015\u0001\u0005\nQ\u000bAAZ7jqR\u0019A$\u0016,\t\u000b)\u0013\u0006\u0019\u0001\u000f\t\u000b]\u0013\u0006\u0019\u0001\u000f\u0002\r1,gn\u001a;i\u0001")
public final class StoreHashFunction {
    public int computeColumnHash(Object key, int seed) {
        block29: {
            int n;
            block3: {
                Object object;
                block28: {
                    block27: {
                        block26: {
                            block25: {
                                block24: {
                                    block23: {
                                        block22: {
                                            block21: {
                                                block20: {
                                                    block19: {
                                                        block18: {
                                                            block17: {
                                                                block16: {
                                                                    block15: {
                                                                        block14: {
                                                                            block13: {
                                                                                block12: {
                                                                                    block11: {
                                                                                        block10: {
                                                                                            block9: {
                                                                                                block8: {
                                                                                                    block7: {
                                                                                                        block6: {
                                                                                                            block5: {
                                                                                                                block4: {
                                                                                                                    block2: {
                                                                                                                        object = key;
                                                                                                                        if (object != null) break block2;
                                                                                                                        n = seed;
                                                                                                                        break block3;
                                                                                                                    }
                                                                                                                    if (!(object instanceof SQLChar)) break block4;
                                                                                                                    SQLChar sQLChar = (SQLChar)object;
                                                                                                                    n = this.computeStringHash(sQLChar.getCharArray(true), seed);
                                                                                                                    break block3;
                                                                                                                }
                                                                                                                if (!(object instanceof SQLInteger)) break block5;
                                                                                                                SQLInteger sQLInteger = (SQLInteger)object;
                                                                                                                n = Murmur3_x86_32.hashInt((int)sQLInteger.getInt(), (int)seed);
                                                                                                                break block3;
                                                                                                            }
                                                                                                            if (!(object instanceof SQLLongint)) break block6;
                                                                                                            SQLLongint sQLLongint = (SQLLongint)object;
                                                                                                            n = Murmur3_x86_32.hashLong((long)sQLLongint.getLong(), (int)seed);
                                                                                                            break block3;
                                                                                                        }
                                                                                                        if (!(object instanceof SQLDouble)) break block7;
                                                                                                        SQLDouble sQLDouble = (SQLDouble)object;
                                                                                                        n = Murmur3_x86_32.hashLong((long)Double.doubleToLongBits(sQLDouble.getDouble()), (int)seed);
                                                                                                        break block3;
                                                                                                    }
                                                                                                    if (!(object instanceof SQLBoolean)) break block8;
                                                                                                    SQLBoolean sQLBoolean = (SQLBoolean)object;
                                                                                                    n = Murmur3_x86_32.hashInt((int)(sQLBoolean.getBoolean() ? 1 : 0), (int)seed);
                                                                                                    break block3;
                                                                                                }
                                                                                                if (!(object instanceof SQLTinyint)) break block9;
                                                                                                SQLTinyint sQLTinyint = (SQLTinyint)object;
                                                                                                n = Murmur3_x86_32.hashInt((int)sQLTinyint.getByte(), (int)seed);
                                                                                                break block3;
                                                                                            }
                                                                                            if (!(object instanceof SQLSmallint)) break block10;
                                                                                            SQLSmallint sQLSmallint = (SQLSmallint)object;
                                                                                            n = Murmur3_x86_32.hashInt((int)sQLSmallint.getShort(), (int)seed);
                                                                                            break block3;
                                                                                        }
                                                                                        if (!(object instanceof SQLReal)) break block11;
                                                                                        SQLReal sQLReal = (SQLReal)object;
                                                                                        n = Murmur3_x86_32.hashInt((int)Float.floatToIntBits(sQLReal.getFloat()), (int)seed);
                                                                                        break block3;
                                                                                    }
                                                                                    if (!(object instanceof SQLDecimal)) break block12;
                                                                                    SQLDecimal sQLDecimal = (SQLDecimal)object;
                                                                                    byte[] bytes = sQLDecimal.getBigDecimal().unscaledValue().toByteArray();
                                                                                    n = Murmur3_x86_32.hashUnsafeBytes((Object)bytes, (long)Platform.BYTE_ARRAY_OFFSET, (int)bytes.length, (int)seed);
                                                                                    break block3;
                                                                                }
                                                                                if (!(object instanceof SQLTimestamp)) break block13;
                                                                                SQLTimestamp sQLTimestamp = (SQLTimestamp)object;
                                                                                long tsVal = sQLTimestamp.getEpochTime(null) * 1000L + (long)sQLTimestamp.getNanos() / 1000L;
                                                                                n = Murmur3_x86_32.hashLong((long)tsVal, (int)seed);
                                                                                break block3;
                                                                            }
                                                                            if (!(object instanceof SQLDate)) break block14;
                                                                            SQLDate sQLDate = (SQLDate)object;
                                                                            int days = DateTimeUtils$.MODULE$.millisToDays(sQLDate.getTimeInMillis(null));
                                                                            n = Murmur3_x86_32.hashInt((int)days, (int)seed);
                                                                            break block3;
                                                                        }
                                                                        if (!(object instanceof SQLBit)) break block15;
                                                                        SQLBit sQLBit = (SQLBit)object;
                                                                        byte[] a = sQLBit.getBytes();
                                                                        n = Murmur3_x86_32.hashUnsafeBytes((Object)a, (long)Platform.BYTE_ARRAY_OFFSET, (int)a.length, (int)seed);
                                                                        break block3;
                                                                    }
                                                                    if (!(object instanceof String)) break block16;
                                                                    String string = (String)object;
                                                                    int len = string.length();
                                                                    char[] internalChars = ResolverUtils.getInternalCharsOnly((String)string, (int)len);
                                                                    n = internalChars != null ? this.computeStringHash(internalChars, seed) : this.computeStringHash(ResolverUtils.getChars((String)string, (int)len), seed);
                                                                    break block3;
                                                                }
                                                                if (!(object instanceof Integer)) break block17;
                                                                int n2 = BoxesRunTime.unboxToInt((Object)object);
                                                                n = Murmur3_x86_32.hashInt((int)n2, (int)seed);
                                                                break block3;
                                                            }
                                                            if (!(object instanceof Long)) break block18;
                                                            long l = BoxesRunTime.unboxToLong((Object)object);
                                                            n = Murmur3_x86_32.hashLong((long)l, (int)seed);
                                                            break block3;
                                                        }
                                                        if (!(object instanceof Double)) break block19;
                                                        double d = BoxesRunTime.unboxToDouble((Object)object);
                                                        n = Murmur3_x86_32.hashLong((long)Double.doubleToLongBits(d), (int)seed);
                                                        break block3;
                                                    }
                                                    if (!(object instanceof Boolean)) break block20;
                                                    boolean bl = BoxesRunTime.unboxToBoolean((Object)object);
                                                    n = Murmur3_x86_32.hashInt((int)(bl ? 1 : 0), (int)seed);
                                                    break block3;
                                                }
                                                if (!(object instanceof Byte)) break block21;
                                                byte by = BoxesRunTime.unboxToByte((Object)object);
                                                n = Murmur3_x86_32.hashInt((int)by, (int)seed);
                                                break block3;
                                            }
                                            if (!(object instanceof Short)) break block22;
                                            short s = BoxesRunTime.unboxToShort((Object)object);
                                            n = Murmur3_x86_32.hashInt((int)s, (int)seed);
                                            break block3;
                                        }
                                        if (!(object instanceof Float)) break block23;
                                        float f = BoxesRunTime.unboxToFloat((Object)object);
                                        n = Murmur3_x86_32.hashInt((int)Float.floatToIntBits(f), (int)seed);
                                        break block3;
                                    }
                                    if (!(object instanceof Decimal)) break block24;
                                    Decimal decimal = (Decimal)object;
                                    byte[] bytes = decimal.toJavaBigDecimal().unscaledValue().toByteArray();
                                    n = Murmur3_x86_32.hashUnsafeBytes((Object)bytes, (long)Platform.BYTE_ARRAY_OFFSET, (int)bytes.length, (int)seed);
                                    break block3;
                                }
                                if (!(object instanceof Timestamp)) break block25;
                                Timestamp timestamp = (Timestamp)object;
                                long tsVal = DateTimeUtils$.MODULE$.fromJavaTimestamp(timestamp);
                                n = Murmur3_x86_32.hashLong((long)tsVal, (int)seed);
                                break block3;
                            }
                            if (!(object instanceof Date)) break block26;
                            Date date = (Date)object;
                            int days = DateTimeUtils$.MODULE$.millisToDays(date.getTime());
                            n = Murmur3_x86_32.hashInt((int)days, (int)seed);
                            break block3;
                        }
                        if (!(object instanceof byte[])) break block27;
                        byte[] byArray = (byte[])object;
                        n = Murmur3_x86_32.hashUnsafeBytes((Object)byArray, (long)Platform.BYTE_ARRAY_OFFSET, (int)byArray.length, (int)seed);
                        break block3;
                    }
                    if (!(object instanceof CalendarInterval)) break block28;
                    CalendarInterval calendarInterval = (CalendarInterval)object;
                    n = Murmur3_x86_32.hashInt((int)calendarInterval.months, (int)Murmur3_x86_32.hashLong((long)calendarInterval.microseconds, (int)seed));
                    break block3;
                }
                if (!(object instanceof UTF8String)) break block29;
                UTF8String uTF8String = (UTF8String)object;
                n = Murmur3_x86_32.hashUnsafeBytes((Object)uTF8String.getBaseObject(), (long)uTF8String.getBaseOffset(), (int)uTF8String.numBytes(), (int)seed);
            }
            return n;
        }
        throw new IllegalStateException(new StringBuilder().append((Object)"Unknown object of class ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key.getClass().getCanonicalName(), key}))).toString());
    }

    public int computeHash(Object key, int numPartitions) {
        int hash = this.computeColumnHash(key, 42) % numPartitions;
        return hash >= 0 ? hash : hash + numPartitions;
    }

    public int computeHash(Object[] objs, int numPartitions) {
        int result = 42;
        int len = objs.length;
        for (int i = 0; i < len; ++i) {
            result = this.computeColumnHash(objs[i], result);
        }
        int hash = result % numPartitions;
        return hash >= 0 ? hash : hash + numPartitions;
    }

    private int computeStringHash(char[] data, int seed) {
        if (data == null) {
            return seed;
        }
        IntRef currentInt = IntRef.create((int)0);
        IntRef shift = IntRef.create((int)0);
        IntRef result = IntRef.create((int)seed);
        int end = data.length;
        int bytesLen = 0;
        for (int index = 0; index < end; ++index) {
            char c = data[index];
            if (c < '\u0080') {
                if (shift.elem < 32) {
                    currentInt.elem |= c << shift.elem;
                    shift.elem += 8;
                } else {
                    result.elem = this.mixH1(result.elem, this.mixK1(currentInt.elem));
                    currentInt.elem = c;
                    shift.elem = 8;
                }
                ++bytesLen;
                continue;
            }
            if (c < '\u0800') {
                if (shift.elem < 24) {
                    currentInt.elem |= (c >> 6 | 0xC0) << shift.elem;
                    shift.elem += 8;
                    currentInt.elem |= (c & 0x3F | 0x80) << shift.elem;
                    shift.elem += 8;
                } else {
                    this.addToHash$1(c >> 6 | 0xC0, currentInt, shift, result);
                    this.addToHash$1(c & 0x3F | 0x80, currentInt, shift, result);
                }
                bytesLen += 2;
                continue;
            }
            if (Character.isSurrogate(c)) {
                char low;
                char c2 = low = ++index != end ? data[index] : (char)'\u0000';
                if (Character.isSurrogatePair(c, low)) {
                    int sch = Character.toCodePoint(c, low);
                    if (shift.elem == 32) {
                        result.elem = this.mixH1(result.elem, this.mixK1(currentInt.elem));
                        currentInt.elem = sch >> 18 | 0xF0;
                        currentInt.elem |= (sch >> 12 & 0x3F | 0x80) << 8;
                        currentInt.elem |= (sch >> 6 & 0x3F | 0x80) << 16;
                        currentInt.elem |= (sch & 0x3F | 0x80) << 24;
                    } else {
                        this.addToHash$1(sch >> 18 | 0xF0, currentInt, shift, result);
                        this.addToHash$1(sch >> 12 & 0x3F | 0x80, currentInt, shift, result);
                        this.addToHash$1(sch >> 6 & 0x3F | 0x80, currentInt, shift, result);
                        this.addToHash$1(sch & 0x3F | 0x80, currentInt, shift, result);
                    }
                    bytesLen += 4;
                    continue;
                }
                throw new IllegalStateException("The supplementary unicode is not in proper format");
            }
            this.addToHash$1(c >> 12 | 0xE0, currentInt, shift, result);
            this.addToHash$1(c >> 6 & 0x3F | 0x80, currentInt, shift, result);
            this.addToHash$1(c & 0x3F | 0x80, currentInt, shift, result);
            bytesLen += 3;
        }
        if (shift.elem == 32) {
            result.elem = this.mixH1(result.elem, this.mixK1(currentInt.elem));
        } else {
            for (int shift2 = 0; shift2 < shift.elem; shift2 += 8) {
                byte k1 = (byte)(currentInt.elem >>> shift2);
                result.elem = this.mixH1(result.elem, this.mixK1(k1));
            }
        }
        return this.fmix(result.elem, bytesLen);
    }

    /*
     * WARNING - void declaration
     */
    private int mixK1(int v) {
        void var2_2;
        int k1 = v;
        k1 *= -862048943;
        k1 = Integer.rotateLeft(k1, 15);
        k1 *= 461845907;
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private int mixH1(int v1, int v2) {
        void var3_3;
        int h1 = v1;
        int k1 = v2;
        h1 ^= k1;
        h1 = Integer.rotateLeft(h1, 13);
        h1 = h1 * 5 + -430675100;
        return (int)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private int fmix(int v, int length) {
        void var3_3;
        int h1 = v;
        h1 ^= length;
        h1 ^= h1 >>> 16;
        h1 *= -2048144789;
        h1 ^= h1 >>> 13;
        h1 *= -1028477387;
        h1 ^= h1 >>> 16;
        return (int)var3_3;
    }

    private final void addToHash$1(int c, IntRef currentInt$1, IntRef shift$1, IntRef result$1) {
        if (shift$1.elem < 32) {
            currentInt$1.elem |= c << shift$1.elem;
            shift$1.elem += 8;
        } else {
            result$1.elem = this.mixH1(result$1.elem, this.mixK1(currentInt$1.elem));
            currentInt$1.elem = c;
            shift$1.elem = 8;
        }
    }
}

