/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.streaming;

import org.apache.spark.Logging;
import org.apache.spark.Logging$class;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.sources.DependencyCatalog$;
import org.apache.spark.streaming.Time;
import org.apache.spark.streaming.dstream.DStream;
import org.apache.spark.streaming.dstream.InputDStream;
import org.apache.spark.streaming.dstream.ReceiverInputDStream;
import org.apache.spark.streaming.receiver.Receiver;
import org.slf4j.Logger;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.HashMap;
import scala.runtime.BoxedUnit;
import scala.runtime.TraitSetter;

public final class StreamBaseRelation$
implements Logging,
Serializable {
    public static final StreamBaseRelation$ MODULE$;
    private final HashMap<String, DStream<InternalRow>> tableToStream;
    private final Object LOCK;
    private Time validTime;
    private transient Logger org$apache$spark$Logging$$log_;
    private transient int org$apache$spark$Logging$$levelFlags;

    static {
        new StreamBaseRelation$();
    }

    @Override
    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    @Override
    @TraitSetter
    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    @Override
    public int org$apache$spark$Logging$$levelFlags() {
        return this.org$apache$spark$Logging$$levelFlags;
    }

    @Override
    public void org$apache$spark$Logging$$levelFlags_$eq(int x$1) {
        this.org$apache$spark$Logging$$levelFlags = x$1;
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public Logger log() {
        return Logging$class.log(this);
    }

    @Override
    public final boolean isInfoEnabled() {
        return Logging$class.isInfoEnabled(this);
    }

    @Override
    public final boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public final boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging$class.initializeLogIfNecessary(this, isInterpreter);
    }

    public Time validTime() {
        return this.validTime;
    }

    public void validTime_$eq(Time x$1) {
        this.validTime = x$1;
    }

    public void setValidTime(Time time) {
        if (this.validTime() == null) {
            this.validTime_$eq(time);
        } else {
            Time time2 = this.validTime();
            Time time3 = time;
            if (time2 == null ? time3 != null : !time2.equals(time3)) {
                this.validTime_$eq(time);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DStream<InternalRow> org$apache$spark$sql$streaming$StreamBaseRelation$$getOrCreateRowStream(String tableName, Function0<Tuple2<DStream<InternalRow>, Seq<String>>> createStream) {
        Object object = this.LOCK;
        synchronized (object) {
            Option option;
            block5: {
                DStream stream;
                DStream dStream;
                option = this.tableToStream.get((Object)tableName);
                if (None$.MODULE$.equals(option)) {
                    Tuple2 tuple2;
                    Tuple2 tuple22 = (Tuple2)createStream.apply();
                    if (tuple22 == null) throw new MatchError((Object)tuple22);
                    DStream stream2 = (DStream)tuple22._1();
                    Seq dependents = (Seq)tuple22._2();
                    Tuple2 tuple23 = tuple2 = new Tuple2((Object)stream2, (Object)dependents);
                    DStream stream3 = (DStream)tuple23._1();
                    Seq dependents2 = (Seq)tuple23._2();
                    this.tableToStream.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tableName), (Object)stream3));
                    DependencyCatalog$.MODULE$.addDependents(tableName, (Seq<String>)dependents2);
                    dStream = stream3;
                    return dStream;
                }
                if (!(option instanceof Some)) break block5;
                Some some = (Some)option;
                dStream = stream = (DStream)some.x();
                return dStream;
            }
            throw new MatchError((Object)option);
        }
    }

    public Option<DStream<InternalRow>> org$apache$spark$sql$streaming$StreamBaseRelation$$removeStream(String tableName) {
        Object object = this.LOCK;
        synchronized (object) {
            Option option = this.tableToStream.remove((Object)tableName);
            return option;
        }
    }

    public void stopStream(DStream<?> stream) {
        ReceiverInputDStream receiverInputDStream;
        DStream<?> dStream = stream;
        if (dStream instanceof ReceiverInputDStream) {
            BoxedUnit boxedUnit;
            receiverInputDStream = (ReceiverInputDStream)dStream;
            Receiver receiver = receiverInputDStream.getReceiver();
            if (receiver == null || receiver.isStopped()) {
                boxedUnit = BoxedUnit.UNIT;
            } else {
                receiver.stop("destroyRelation");
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else if (dStream instanceof InputDStream) {
            InputDStream inputDStream = (InputDStream)dStream;
            inputDStream.stop();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        return;
        finally {
            receiverInputDStream.stop();
        }
    }

    public void clearStreams() {
        Object object = this.LOCK;
        synchronized (object) {
            this.tableToStream.clear();
            return;
        }
    }

    private Object readResolve() {
        return MODULE$;
    }

    private StreamBaseRelation$() {
        MODULE$ = this;
        Logging$class.$init$(this);
        this.tableToStream = new HashMap();
        this.LOCK = new Object();
    }
}

