/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.streaming;

import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.JavaTypeInference$;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder$;
import org.apache.spark.sql.catalyst.encoders.RowEncoder$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.apache.spark.sql.hive.SnappyStoreHiveCatalog;
import org.apache.spark.sql.hive.SnappyStoreHiveCatalog$;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.streaming.LogicalDStreamPlan;
import org.apache.spark.sql.streaming.SchemaDStream;
import org.apache.spark.sql.streaming.StreamBaseRelation$;
import org.apache.spark.sql.streaming.StreamPlan;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.streaming.SnappyStreamingContext;
import org.apache.spark.streaming.api.java.JavaDStream;
import org.apache.spark.streaming.dstream.DStream;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.api.TypeTags;

public final class StreamSqlHelper$ {
    public static final StreamSqlHelper$ MODULE$;

    static {
        new StreamSqlHelper$();
    }

    public void registerRelationDestroy() {
        SnappyStoreHiveCatalog$.MODULE$.registerRelationDestroy();
    }

    public void clearStreams() {
        StreamBaseRelation$.MODULE$.clearStreams();
    }

    public Seq<AttributeReference> getSchema(Class<?> beanClass) {
        Tuple2 tuple2 = JavaTypeInference$.MODULE$.inferDataType(beanClass);
        if (tuple2 != null) {
            DataType dataType;
            DataType dataType2;
            DataType dataType3 = dataType2 = (dataType = (DataType)tuple2._1());
            return (Seq)Predef$.MODULE$.refArrayOps((Object[])((StructType)dataType3).fields()).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final AttributeReference apply(StructField f) {
                    String x$4 = f.name();
                    DataType x$5 = f.dataType();
                    boolean x$6 = f.nullable();
                    Metadata x$7 = AttributeReference$.MODULE$.apply$default$4();
                    ExprId x$8 = AttributeReference$.MODULE$.apply$default$5(x$4, x$5, x$6, x$7);
                    Option x$9 = AttributeReference$.MODULE$.apply$default$6(x$4, x$5, x$6, x$7);
                    Boolean x$10 = AttributeReference$.MODULE$.apply$default$7(x$4, x$5, x$6, x$7);
                    return new AttributeReference(x$4, x$5, x$6, x$7, x$8, x$9, x$10);
                }
            }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
        }
        throw new MatchError((Object)tuple2);
    }

    public SchemaDStream getSchemaDStream(SnappyStreamingContext ssc, String tableName) {
        LogicalRelation logicalRelation;
        BaseRelation sr;
        SnappyStoreHiveCatalog catalog = ssc.snappySession().sessionState().catalog();
        LogicalPlan logicalPlan = catalog.lookupRelation(catalog.newQualifiedTableName(tableName));
        if (logicalPlan instanceof LogicalRelation && (sr = (logicalRelation = (LogicalRelation)logicalPlan).relation()) instanceof StreamPlan) {
            BaseRelation baseRelation = sr;
            SchemaDStream schemaDStream = new SchemaDStream(ssc, new LogicalDStreamPlan((Seq<Attribute>)((StreamPlan)baseRelation).schema().toAttributes(), ((StreamPlan)baseRelation).rowStream(), ssc));
            return schemaDStream;
        }
        throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Table ", " not a stream table"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public <A extends Product> SchemaDStream createSchemaDStream(SnappyStreamingContext ssc, DStream<A> stream, TypeTags.TypeTag<A> evidence$1) {
        ExpressionEncoder encoder = ExpressionEncoder$.MODULE$.apply(evidence$1);
        StructType schema = encoder.schema();
        LogicalDStreamPlan logicalPlan = new LogicalDStreamPlan((Seq<Attribute>)schema.toAttributes(), (DStream<InternalRow>)stream.map((Function1)new Serializable(encoder){
            public static final long serialVersionUID = 0L;
            private final ExpressionEncoder encoder$1;

            public final InternalRow apply(A x$1) {
                return this.encoder$1.toRow(x$1).copy();
            }
            {
                this.encoder$1 = encoder$1;
            }
        }, ClassTag$.MODULE$.apply(InternalRow.class)), ssc);
        return new SchemaDStream(ssc, logicalPlan);
    }

    public SchemaDStream createSchemaDStream(SnappyStreamingContext ssc, DStream<Row> rowStream2, StructType schema) {
        ExpressionEncoder encoder = RowEncoder$.MODULE$.apply(schema);
        LogicalDStreamPlan logicalPlan = new LogicalDStreamPlan((Seq<Attribute>)schema.toAttributes(), (DStream<InternalRow>)rowStream2.map((Function1)new Serializable(encoder){
            public static final long serialVersionUID = 0L;
            private final ExpressionEncoder encoder$2;

            public final InternalRow apply(Row x$2) {
                return this.encoder$2.toRow((Object)x$2).copy();
            }
            {
                this.encoder$2 = encoder$2;
            }
        }, ClassTag$.MODULE$.apply(InternalRow.class)), ssc);
        return new SchemaDStream(ssc, logicalPlan);
    }

    public SchemaDStream createSchemaDStream(SnappyStreamingContext ssc, JavaDStream<?> rowStream2, Class<?> beanClass) {
        ExpressionEncoder encoder = ExpressionEncoder$.MODULE$.javaBean(beanClass);
        StructType schema = encoder.schema();
        LogicalDStreamPlan logicalPlan = new LogicalDStreamPlan((Seq<Attribute>)schema.toAttributes(), (DStream<InternalRow>)rowStream2.dstream().map((Function1)new Serializable(encoder){
            public static final long serialVersionUID = 0L;
            private final ExpressionEncoder encoder$3;

            public final InternalRow apply(Object x$3) {
                return this.encoder$3.toRow(x$3).copy();
            }
            {
                this.encoder$3 = encoder$3;
            }
        }, ClassTag$.MODULE$.apply(InternalRow.class)), ssc);
        return new SchemaDStream(ssc, logicalPlan);
    }

    private StreamSqlHelper$() {
        MODULE$ = this;
    }
}

