/*
 * Decompiled with CFR 0.152.
 */
package io.snice.codecs.codec.diameter.avp;

import java.util.Optional;

public enum Vendor {
    NONE(0L, "None"),
    MERIT(61L, "Merit Networks"),
    USR(429L, "US Robotics Corp."),
    LUCENT(1751L, "Lucent Technologies"),
    DEUTSCHE_TELEKOM_AG(2937L, "Deutsche Telekom AG"),
    ACISION(3830L, "Acision"),
    SKT(5806L, "SK Telecom"),
    TGPP(10415L, "3GPP"),
    ETSI(13019L, "ETSI"),
    TANGO(13421L, "Tango Telecom Limited"),
    CHINATELECOM(81000L, "China Telecom"),
    TGPPCX(0x1000000L, "3GPP CX/DX");

    private final long code;
    private final String friendlyName;

    private Vendor(long code, String friendlyName) {
        this.code = code;
        this.friendlyName = friendlyName;
    }

    public static Optional<Vendor> getValue(String name) {
        for (Vendor v : Vendor.values()) {
            if (!v.toString().replace("_", "").equalsIgnoreCase(name)) continue;
            return Optional.of(v);
        }
        return Optional.empty();
    }

    public static Optional<Vendor> getValue(long value) {
        for (Vendor v : Vendor.values()) {
            if (v.code != value) continue;
            return Optional.of(v);
        }
        return Optional.empty();
    }

    public long getCode() {
        return this.code;
    }

    public String getFriendlyName() {
        return this.friendlyName;
    }
}

