package io.snice.codecs.codec.gtp.gtpc;

import io.snice.buffer.Buffer;
import io.snice.codecs.codec.gtp.gtpc.v2.tliv.TypeLengthInstanceValue;
import io.snice.codecs.codec.gtp.gtpc.v2.type.GtpType;

public interface InfoElement<T extends GtpType> {

    byte getType();

    T getValue();

    default int getTypeAsDecimal() {
        return Byte.toUnsignedInt(getType());
    }

    int getLength();

    /**
     * See TS 29.274 section 8.2 and section 6.1.3.
     *
     * In short, both the type and the instance number is used to identify
     * exactly what a particular IE means. This to disambiguate IE of the same
     * type from each other.
     *
     * @return the instance number of this TLIV (it's only 4 bits so values will only be between 0-15)
     */
    int getInstance();

    /**
     * Get the full "raw" buffer, which represents the entire info element, including
     * any headers etc.
     *
     * @return
     */
    Buffer getRaw();

    /**
     * As most things in this library are done lazily, such as framing info elements (IE), You can make sure
     * that a particular IE has indeed been parsed to the more specific IE type by calling
     * this method. If the IE has yet not been parsed fully, e.g., we may have extracted out a
     * {@link } but it is still in its "raw" form and therefore represented as a
     * {@link TypeLengthInstanceValue} as opposed to an actual {@link ContactHeader} but by calling this method
     * you will force the library to actually fully frame it.
     * <p>
     * Note, if the header is successfully parsed into a more explicit header type you may
     * still not really know what to cast it so in order to make life somewhat easier you can
     * use the isXxxxIE methods (such as {@link SipHeader#isAddressParametersHeader()} to
     * check what type it possible can be and then use the corresponding toXxxxxIE to
     * "cast" it.
     *
     * @return
     */
    // <V extends InfoElement<T>> V ensure();

    default boolean isTypeLengthInstanceValue() {
        return false;
    }

    default TypeLengthInstanceValue toTliv() throws ClassCastException {
        throw new ClassCastException("Unable to cast a " + getClass().getName() + " into a " + TypeLengthInstanceValue.class.getName());
    }
}
