package io.snice.codecs.codec.gtp.gtpc.v1;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

/**
 * This file has been auto generated. Do not manually edit.
 *
 * @author jonas@jonasborjesson.com
 */
public enum Gtp1MessageType {
    ECHO_REQUEST(1, true, true, true, "7.2.1"),
    ECHO_RESPONSE(2, true, true, true, "7.2.2"),
    VERSION_NOT_SUPPORTED(3, true, false, true, "7.2.3"),
    NODE_ALIVE_REQUEST(4, false, false, true, "3GPP TS 32.295 [33]"),
    NODE_ALIVE_RESPONSE(5, false, false, true, "3GPP TS 32.295 [33]"),
    REDIRECTION_REQUEST(6, false, false, true, "3GPP TS 32.295 [33]"),
    REDIRECTION_RESPONSE(7, false, false, true, "3GPP TS 32.295 [33]"),
    CREATE_PDP_CONTEXT_REQUEST(16, true, false, false, "7.3.1"),
    CREATE_PDP_CONTEXT_RESPONSE(17, true, false, false, "7.3.2"),
    UPDATE_PDP_CONTEXT_REQUEST(18, true, false, false, "7.3.3"),
    UPDATE_PDP_CONTEXT_RESPONSE(19, true, false, false, "7.3.4"),
    DELETE_PDP_CONTEXT_REQUEST(20, true, false, false, "7.3.5"),
    DELETE_PDP_CONTEXT_RESPONSE(21, true, false, false, "7.3.6"),
    INITIATE_PDP_CONTEXT_ACTIVATION_REQUEST(22, true, false, false, "7.3.12"),
    INITIATE_PDP_CONTEXT_ACTIVATION_RESPONSE(23, true, false, false, "7.3.13"),
    ERROR_INDICATION(26, false, true, false, "3GPP TS 29.281 [41]"),
    PDU_NOTIFICATION_REQUEST(27, true, false, false, "7.3.8"),
    PDU_NOTIFICATION_RESPONSE(28, true, false, false, "7.3.9"),
    PDU_NOTIFICATION_REJECT_REQUEST(29, true, false, false, "7.3.10"),
    PDU_NOTIFICATION_REJECT_RESPONSE(30, true, false, false, "7.3.11"),
    SUPPORTED_EXTENSION_HEADERS_NOTIFICATION(31, true, true, false, "7.2.4"),
    SEND_ROUTEING_INFORMATION_FOR_GPRS_REQUEST(32, true, false, false, "7.4.1"),
    SEND_ROUTEING_INFORMATION_FOR_GPRS_RESPONSE(33, true, false, false, "7.4.2"),
    FAILURE_REPORT_REQUEST(34, true, false, false, "7.4.3"),
    FAILURE_REPORT_RESPONSE(35, true, false, false, "7.4.4"),
    NOTE_MS_GPRS_PRESENT_REQUEST(36, true, false, false, "7.4.5"),
    NOTE_MS_GPRS_PRESENT_RESPONSE(37, true, false, false, "7.4.6"),
    IDENTIFICATION_REQUEST(48, true, false, false, "7.5.1"),
    IDENTIFICATION_RESPONSE(49, true, false, false, "7.5.2"),
    SGSN_CONTEXT_REQUEST(50, true, false, false, "7.5.3"),
    SGSN_CONTEXT_RESPONSE(51, true, false, false, "7.5.4"),
    SGSN_CONTEXT_ACKNOWLEDGE(52, true, false, false, "7.5.5"),
    FORWARD_RELOCATION_REQUEST(53, true, false, false, "7.5.6"),
    FORWARD_RELOCATION_RESPONSE(54, true, false, false, "7.5.7"),
    FORWARD_RELOCATION_COMPLETE(55, true, false, false, "7.5.8"),
    RELOCATION_CANCEL_REQUEST(56, true, false, false, "7.5.9"),
    RELOCATION_CANCEL_RESPONSE(57, true, false, false, "7.5.10"),
    FORWARD_SRNS_CONTEXT(58, true, false, false, "7.5.13"),
    FORWARD_RELOCATION_COMPLETE_ACKNOWLEDGE(59, true, false, false, "7.5.11"),
    FORWARD_SRNS_CONTEXT_ACKNOWLEDGE(60, true, false, false, "7.5.12"),
    RAN_INFORMATION_RELAY(70, true, false, false, "7.5.14.1"),
    MBMS_NOTIFICATION_REQUEST(96, true, false, false, "7.5A.1.1"),
    MBMS_NOTIFICATION_RESPONSE(97, true, false, false, "7.5A.1.2"),
    MBMS_NOTIFICATION_REJECT_REQUEST(98, true, false, false, "7.5A.1.3"),
    MBMS_NOTIFICATION_REJECT_RESPONSE(99, true, false, false, "7.5A.1.4"),
    CREATE_MBMS_CONTEXT_REQUEST(100, true, false, false, "7.5A.1.5"),
    CREATE_MBMS_CONTEXT_RESPONSE(101, true, false, false, "7.5A.1.6"),
    UPDATE_MBMS_CONTEXT_REQUEST(102, true, false, false, "7.5A.1.7"),
    UPDATE_MBMS_CONTEXT_RESPONSE(103, true, false, false, "7.5A.1.8"),
    DELETE_MBMS_CONTEXT_REQUEST(104, true, false, false, "7.5A.1.9"),
    DELETE_MBMS_CONTEXT_RESPONSE(105, true, false, false, "7.5A.1.10"),
    MBMS_REGISTRATION_REQUEST(112, true, false, false, "7.5A.2.1"),
    MBMS_REGISTRATION_RESPONSE(113, true, false, false, "7.5A.2.2"),
    MBMS_DEREGISTRATION_REQUEST(114, true, false, false, "7.5A.2.3"),
    MBMS_DEREGISTRATION_RESPONSE(115, true, false, false, "7.5A.2.4"),
    MBMS_SESSION_START_REQUEST(116, true, false, false, "7.5A.2.5"),
    MBMS_SESSION_START_RESPONSE(117, true, false, false, "7.5A.2.6"),
    MBMS_SESSION_STOP_REQUEST(118, true, false, false, "7.5A.2.7"),
    MBMS_SESSION_STOP_RESPONSE(119, true, false, false, "7.5A.2.8"),
    MBMS_SESSION_UPDATE_REQUEST(120, true, false, false, "7.5A.2.9"),
    MBMS_SESSION_UPDATE_RESPONSE(121, true, false, false, "7.5A.2.10"),
    MS_INFO_CHANGE_NOTIFICATION_REQUEST(128, true, false, false, "7.5B.1.1"),
    MS_INFO_CHANGE_NOTIFICATION_RESPONSE(129, true, false, false, "7.5B.1.2"),
    DATA_RECORD_TRANSFER_REQUEST(240, false, false, true, "3GPP TS 32.295 [33]"),
    DATA_RECORD_TRANSFER_RESPONSE(241, false, false, true, "3GPP TS 32.295 [33]"),
    END_MARKER(254, false, true, false, "3GPP TS 29.281 [41]"),
    G_PDU(255, false, true, false, "3GPP TS 29.281 [41]");

    private static Map<Integer, Gtp1MessageType> byType = new HashMap<>();

    static {
        Arrays.stream(Gtp1MessageType.values()).forEach(e -> byType.put(e.getType(), e));
    }

    public static Gtp1MessageType lookup(final int type) {
        return byType.get(type);
    }

    private final int type;
    private final boolean isGtpC;
    private final boolean isGtpU;
    private final boolean isGtpPrime;

    Gtp1MessageType(final int type, final boolean isGtpC, final boolean isGtpU, final boolean isGtpPrime, final String reference) {
        this.type = type;
        this.isGtpC = isGtpC;
        this.isGtpU = isGtpU;
        this.isGtpPrime = isGtpPrime;
    }

    public int getType() {
        return type;
    }

    public boolean isGtpC() {
        return isGtpC;
    }

    public boolean isGtpU() {
        return isGtpU;
    }

    public boolean isGtpPrime() {
        return isGtpPrime;
    }
}
