package io.snice.codecs.codec.gtp.gtpc.v1.impl;

import io.snice.buffer.Buffer;
import io.snice.codecs.codec.gtp.gtpc.v1.Gtp1Header;
import io.snice.codecs.codec.gtp.gtpc.v1.Gtp1Message;
import io.snice.codecs.codec.gtp.gtpc.v1.Gtp1MessageType;

public class GenericGtp1MessageBuilder<T extends Gtp1Message> extends AbstractGtp1MessageBuilder<T> {

    protected GenericGtp1MessageBuilder(final Gtp1MessageType type) {
        super(type);
    }

    @Override
    protected T internalBuild(final Gtp1MessageType type, final Buffer buffer, final Gtp1Header header, final Buffer payload) {
        // TODO: the gtp1 message type doesn't have if the message is a request or response.
        return (T) new ImmutableGtp1Request(type, header, buffer, payload);
    }
}
