package io.snice.codecs.codec.gtp.gtpc.v2;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

/**
 * This file has been auto generated. Do not manually edit.
 *
 * @author jonas@jonasborjesson.com
 */
public enum Gtp2MessageType {
    RESERVED(0, false, false, false, "29.274"),
    ECHO_REQUEST(1, true, true, false, "29.274"),
    ECHO_RESPONSE(2, false, false, true, "29.274"),
    VERSION_NOT_SUPPORTED_INDICATION(3, true, false, true, "29.274"),
    CREATE_SESSION_REQUEST(32, true, true, false, "29.274"),
    CREATE_SESSION_RESPONSE(33, false, false, true, "29.274"),
    DELETE_SESSION_REQUEST(36, true, true, false, "29.274"),
    DELETE_SESSION_RESPONSE(37, false, false, true, "29.274"),
    MODIFY_BEARER_REQUEST(34, true, true, false, "29.274"),
    MODIFY_BEARER_RESPONSE(35, false, false, true, "29.274"),
    REMOTE_UE_REPORT_NOTIFICATION(40, true, true, false, "29.274"),
    REMOTE_UE_REPORT_ACKNOWLEDGE(41, false, false, true, "29.274"),
    CHANGE_NOTIFICATION_REQUEST(38, true, true, false, "29.274"),
    CHANGE_NOTIFICATION_RESPONSE(39, false, false, true, "29.274"),
    RESUME_NOTIFICATION(164, true, true, false, "29.274"),
    RESUME_ACKNOWLEDGE(165, false, false, true, "29.274"),
    MODIFY_BEARER_COMMAND(64, true, true, false, "29.274"),
    MODIFY_BEARER_FAILURE_INDICATION(65, false, false, true, "29.274"),
    DELETE_BEARER_COMMAND(66, true, true, false, "29.274"),
    DELETE_BEARER_FAILURE_INDICATION(67, false, false, true, "29.274"),
    BEARER_RESOURCE_COMMAND(68, true, true, false, "29.274"),
    BEARER_RESOURCE_FAILURE_INDICATION(69, false, false, true, "29.274"),
    DOWNLINK_DATA_NOTIFICATION_FAILURE_INDICATION(70, true, true, false, "29.274"),
    TRACE_SESSION_ACTIVATION(71, true, true, false, "29.274"),
    TRACE_SESSION_DEACTIVATION(72, false, true, false, "29.274"),
    STOP_PAGING_INDICATION(73, true, true, false, "29.274"),
    CREATE_BEARER_REQUEST(95, true, true, true, "29.274"),
    CREATE_BEARER_RESPONSE(96, false, false, true, "29.274"),
    UPDATE_BEARER_REQUEST(97, true, true, true, "29.274"),
    UPDATE_BEARER_RESPONSE(98, false, false, true, "29.274"),
    DELETE_BEARER_REQUEST(99, true, true, true, "29.274"),
    DELETE_BEARER_RESPONSE(100, false, false, true, "29.274"),
    DELETE_PDN_CONNECTION_SET_REQUEST(101, true, true, false, "29.274"),
    DELETE_PDN_CONNECTION_SET_RESPONSE(102, false, false, true, "29.274"),
    PGW_DOWNLINK_TRIGGERING_NOTIFICATION(103, true, true, false, "29.274"),
    PGW_DOWNLINK_TRIGGERING_ACKNOWLEDGE(104, false, false, true, "29.274"),
    IDENTIFICATION_REQUEST(128, true, true, false, "29.274"),
    IDENTIFICATION_RESPONSE(129, false, false, true, "29.274"),
    CONTEXT_REQUEST(130, true, true, false, "29.274"),
    CONTEXT_RESPONSE(131, false, false, true, "29.274"),
    CONTEXT_ACKNOWLEDGE(132, false, false, true, "29.274"),
    FORWARD_RELOCATION_REQUEST(133, true, true, false, "29.274"),
    FORWARD_RELOCATION_RESPONSE(134, false, false, true, "29.274"),
    FORWARD_RELOCATION_COMPLETE_NOTIFICATION(135, true, true, false, "29.274"),
    FORWARD_RELOCATION_COMPLETE_ACKNOWLEDGE(136, false, false, true, "29.274"),
    FORWARD_ACCESS_CONTEXT_NOTIFICATION(137, true, true, false, "29.274"),
    FORWARD_ACCESS_CONTEXT_ACKNOWLEDGE(138, false, false, true, "29.274"),
    RELOCATION_CANCEL_REQUEST(139, true, true, false, "29.274"),
    RELOCATION_CANCEL_RESPONSE(140, false, false, true, "29.274"),
    CONFIGURATION_TRANSFER_TUNNEL(141, true, true, false, "29.274"),
    RAN_INFORMATION_RELAY(152, true, true, false, "29.274"),
    DETACH_NOTIFICATION(149, true, true, false, "29.274"),
    DETACH_ACKNOWLEDGE(150, false, false, true, "29.274"),
    CS_PAGING_INDICATION(151, true, true, false, "29.274"),
    ALERT_MME_NOTIFICATION(153, true, true, false, "29.274"),
    ALERT_MME_ACKNOWLEDGE(154, false, false, true, "29.274"),
    UE_ACTIVITY_NOTIFICATION(155, true, true, false, "29.274"),
    UE_ACTIVITY_ACKNOWLEDGE(156, false, false, true, "29.274"),
    ISR_STATUS_INDICATION(157, true, true, false, "29.274"),
    UE_REGISTRATION_QUERY_REQUEST(158, true, true, false, "29.274"),
    UE_REGISTRATION_QUERY_RESPONSE(159, false, false, true, "29.274"),
    SUSPEND_NOTIFICATION(162, true, true, false, "29.274"),
    SUSPEND_ACKNOWLEDGE(163, false, false, true, "29.274"),
    CREATE_FORWARDING_TUNNEL_REQUEST(160, true, true, false, "29.274"),
    CREATE_FORWARDING_TUNNEL_RESPONSE(161, false, false, true, "29.274"),
    CREATE_INDIRECT_DATA_FORWARDING_TUNNEL_REQUEST(166, true, true, false, "29.274"),
    CREATE_INDIRECT_DATA_FORWARDING_TUNNEL_RESPONSE(167, false, false, true, "29.274"),
    DELETE_INDIRECT_DATA_FORWARDING_TUNNEL_REQUEST(168, true, true, false, "29.274"),
    DELETE_INDIRECT_DATA_FORWARDING_TUNNEL_RESPONSE(169, false, false, true, "29.274"),
    RELEASE_ACCESS_BEARERS_REQUEST(170, true, true, false, "29.274"),
    RELEASE_ACCESS_BEARERS_RESPONSE(171, false, false, true, "29.274"),
    DOWNLINK_DATA_NOTIFICATION(176, true, true, false, "29.274"),
    DOWNLINK_DATA_NOTIFICATION_ACKNOWLEDGE(177, false, false, true, "29.274"),
    PGW_RESTART_NOTIFICATION(179, true, true, false, "29.274"),
    PGW_RESTART_NOTIFICATION_ACKNOWLEDGE(180, false, false, true, "29.274"),
    UPDATE_PDN_CONNECTION_SET_REQUEST(200, true, true, false, "29.274"),
    UPDATE_PDN_CONNECTION_SET_RESPONSE(201, false, false, true, "29.274"),
    MODIFY_ACCESS_BEARERS_REQUEST(211, true, true, false, "29.274"),
    MODIFY_ACCESS_BEARERS_RESPONSE(212, false, false, true, "29.274"),
    MBMS_SESSION_START_REQUEST(231, true, true, false, "29.274"),
    MBMS_SESSION_START_RESPONSE(232, false, false, true, "29.274"),
    MBMS_SESSION_UPDATE_REQUEST(233, true, true, false, "29.274"),
    MBMS_SESSION_UPDATE_RESPONSE(234, false, false, true, "29.274"),
    MBMS_SESSION_STOP_REQUEST(235, true, true, false, "29.274"),
    MBMS_SESSION_STOP_RESPONSE(236, false, false, true, "29.274");

    private static Map<Integer, Gtp2MessageType> byType = new HashMap<>();

    static {
        Arrays.stream(Gtp2MessageType.values()).forEach(e -> byType.put(e.getType(), e));
    }

    public static Gtp2MessageType lookup(final int type) {
        return byType.get(type);
    }

    private final int type;
    private final boolean isRequest;
    private final boolean isInitial;
    private final boolean isTriggered;

    Gtp2MessageType(final int type, final boolean isRequest, final boolean isInitial, final boolean isTriggered, final String specification) {
        this.type = type;
        this.isRequest = isRequest;
        this.isInitial = isInitial;
        this.isTriggered = isTriggered;
    }

    public int getType() {
        return type;
    }

    public boolean isRequest() {
        return isRequest;
    }

    public boolean isInitial() {
        return isInitial;
    }

    public boolean isTriggered() {
        return isTriggered;
    }

}
