package io.snice.codecs.codec.gtp.gtpc.v2.tliv;

import io.snice.buffer.Buffer;
import io.snice.buffer.Buffers;
import io.snice.codecs.codec.gtp.gtpc.v2.tliv.TypeLengthInstanceValue;
import io.snice.codecs.codec.gtp.gtpc.v2.tliv.impl.BaseTliv;
import io.snice.codecs.codec.gtp.gtpc.v2.tliv.impl.RawTypeLengthInstanceValue;
import io.snice.codecs.codec.gtp.gtpc.v2.type.AmbrType;
import io.snice.codecs.codec.gtp.gtpc.v2.Gtp2InfoElement;

import static io.snice.preconditions.PreConditions.assertArgument;
import static io.snice.preconditions.PreConditions.assertNotNull;

/**
 * This file has been auto generated. Do not manually edit.
 * Please see the readme file in the codegen directory
 * for how to update and generate this file.
 *
 * @author jonas@jonasborjesson.com
 */
public interface Ambr extends TypeLengthInstanceValue<AmbrType> {

    Gtp2InfoElement TYPE = Gtp2InfoElement.AMBR;

    /**
     * The raw byte value of the Info Element. Useful when writing switch statements
     * since those needs a constant value.
     */
    int TYPE_VALUE = 72;

    static Ambr frame(final Buffer buffer) {
        final var raw = RawTypeLengthInstanceValue.frame(buffer);
        return frame(raw);
    }

    static Ambr frame(final RawTypeLengthInstanceValue raw) {
        assertNotNull(raw);
        assertArgument(raw.getType() == Ambr.TYPE.getType(), "The given raw TLIV is not an AMBR");
        final var value = AmbrType.parse(raw.getValue().getBuffer());
        return new DefaultAmbr(value, raw);
    }

    static Ambr ofValue(final Buffer buffer) {
        final var value = AmbrType.ofValue(buffer);
        return ofValue(value);
    }

    static Ambr ofValue(final Buffer buffer, final int instance) {
        final var value = AmbrType.ofValue(buffer);
        return ofValue(value, instance);
    }

    static Ambr ofValue(final String buffer) {
        final var value = AmbrType.ofValue(buffer);
        return ofValue(value);
    }

    static Ambr ofValue(final String buffer, final int instance) {
        final var value = AmbrType.ofValue(buffer);
        return ofValue(value, instance);
    }

    static Ambr ofValue(final AmbrType value) {
        return ofValue(value, 0);
    }

    static Ambr ofValue(final AmbrType value, final int instance) {
        final var raw = RawTypeLengthInstanceValue.create(TYPE, instance, value);
        return new DefaultAmbr(value, raw);
    }

    @Override
    default Ambr ensure() {
        return this;
    }

    class DefaultAmbr extends BaseTliv<AmbrType> implements Ambr {
        private DefaultAmbr(AmbrType value, RawTypeLengthInstanceValue raw) {
            super(value, raw);
        }

        public boolean isAmbr() {
            return true;
        }

        public Ambr toAmbr() {
            return this;
        }
    }
}

