package io.snice.codecs.codec.gtp.gtpc.v2.tliv;

import io.snice.buffer.Buffer;
import io.snice.buffer.Buffers;
import io.snice.codecs.codec.gtp.gtpc.v2.tliv.TypeLengthInstanceValue;
import io.snice.codecs.codec.gtp.gtpc.v2.tliv.impl.BaseTliv;
import io.snice.codecs.codec.gtp.gtpc.v2.tliv.impl.RawTypeLengthInstanceValue;
import io.snice.codecs.codec.gtp.gtpc.v2.type.ApnType;
import io.snice.codecs.codec.gtp.gtpc.v2.Gtp2InfoElement;

import static io.snice.preconditions.PreConditions.assertArgument;
import static io.snice.preconditions.PreConditions.assertNotNull;

/**
 * This file has been auto generated. Do not manually edit.
 * Please see the readme file in the codegen directory
 * for how to update and generate this file.
 *
 * @author jonas@jonasborjesson.com
 */
public interface Apn extends TypeLengthInstanceValue<ApnType> {

    Gtp2InfoElement TYPE = Gtp2InfoElement.APN;

    /**
     * The raw byte value of the Info Element. Useful when writing switch statements
     * since those needs a constant value.
     */
    int TYPE_VALUE = 71;

    static Apn frame(final Buffer buffer) {
        final var raw = RawTypeLengthInstanceValue.frame(buffer);
        return frame(raw);
    }

    static Apn frame(final RawTypeLengthInstanceValue raw) {
        assertNotNull(raw);
        assertArgument(raw.getType() == Apn.TYPE.getType(), "The given raw TLIV is not an APN");
        final var value = ApnType.parse(raw.getValue().getBuffer());
        return new DefaultApn(value, raw);
    }

    static Apn ofValue(final Buffer buffer) {
        final var value = ApnType.ofValue(buffer);
        return ofValue(value);
    }

    static Apn ofValue(final Buffer buffer, final int instance) {
        final var value = ApnType.ofValue(buffer);
        return ofValue(value, instance);
    }

    static Apn ofValue(final String buffer) {
        final var value = ApnType.ofValue(buffer);
        return ofValue(value);
    }

    static Apn ofValue(final String buffer, final int instance) {
        final var value = ApnType.ofValue(buffer);
        return ofValue(value, instance);
    }

    static Apn ofValue(final ApnType value) {
        return ofValue(value, 0);
    }

    static Apn ofValue(final ApnType value, final int instance) {
        final var raw = RawTypeLengthInstanceValue.create(TYPE, instance, value);
        return new DefaultApn(value, raw);
    }

    @Override
    default Apn ensure() {
        return this;
    }

    class DefaultApn extends BaseTliv<ApnType> implements Apn {
        private DefaultApn(ApnType value, RawTypeLengthInstanceValue raw) {
            super(value, raw);
        }

        public boolean isApn() {
            return true;
        }

        public Apn toApn() {
            return this;
        }
    }
}

