package io.snice.codecs.codec.gtp.gtpc.v2.tliv;

import io.snice.buffer.Buffer;
import io.snice.buffer.Buffers;
import io.snice.codecs.codec.gtp.gtpc.v2.tliv.TypeLengthInstanceValue;
import io.snice.codecs.codec.gtp.gtpc.v2.tliv.impl.BaseTliv;
import io.snice.codecs.codec.gtp.gtpc.v2.tliv.impl.RawTypeLengthInstanceValue;
import io.snice.codecs.codec.gtp.gtpc.v2.type.RawType;
import io.snice.codecs.codec.gtp.gtpc.v2.Gtp2InfoElement;

import static io.snice.preconditions.PreConditions.assertArgument;
import static io.snice.preconditions.PreConditions.assertNotNull;

/**
 * This file has been auto generated. Do not manually edit.
 * Please see the readme file in the codegen directory
 * for how to update and generate this file.
 *
 * @author jonas@jonasborjesson.com
 */
public interface ApnAndRelativeCapacity extends TypeLengthInstanceValue<RawType> {

    Gtp2InfoElement TYPE = Gtp2InfoElement.APN_AND_RELATIVE_CAPACITY;

    /**
     * The raw byte value of the Info Element. Useful when writing switch statements
     * since those needs a constant value.
     */
    int TYPE_VALUE = 184;

    static ApnAndRelativeCapacity frame(final Buffer buffer) {
        final var raw = RawTypeLengthInstanceValue.frame(buffer);
        return frame(raw);
    }

    static ApnAndRelativeCapacity frame(final RawTypeLengthInstanceValue raw) {
        assertNotNull(raw);
        assertArgument(raw.getType() == ApnAndRelativeCapacity.TYPE.getType(), "The given raw TLIV is not an APN_AND_RELATIVE_CAPACITY");
        final var value = RawType.parse(raw.getValue().getBuffer());
        return new DefaultApnAndRelativeCapacity(value, raw);
    }

    static ApnAndRelativeCapacity ofValue(final Buffer buffer) {
        final var value = RawType.ofValue(buffer);
        return ofValue(value);
    }

    static ApnAndRelativeCapacity ofValue(final Buffer buffer, final int instance) {
        final var value = RawType.ofValue(buffer);
        return ofValue(value, instance);
    }

    static ApnAndRelativeCapacity ofValue(final String buffer) {
        final var value = RawType.ofValue(buffer);
        return ofValue(value);
    }

    static ApnAndRelativeCapacity ofValue(final String buffer, final int instance) {
        final var value = RawType.ofValue(buffer);
        return ofValue(value, instance);
    }

    static ApnAndRelativeCapacity ofValue(final RawType value) {
        return ofValue(value, 0);
    }

    static ApnAndRelativeCapacity ofValue(final RawType value, final int instance) {
        final var raw = RawTypeLengthInstanceValue.create(TYPE, instance, value);
        return new DefaultApnAndRelativeCapacity(value, raw);
    }

    @Override
    default ApnAndRelativeCapacity ensure() {
        return this;
    }

    class DefaultApnAndRelativeCapacity extends BaseTliv<RawType> implements ApnAndRelativeCapacity {
        private DefaultApnAndRelativeCapacity(RawType value, RawTypeLengthInstanceValue raw) {
            super(value, raw);
        }

        public boolean isApnAndRelativeCapacity() {
            return true;
        }

        public ApnAndRelativeCapacity toApnAndRelativeCapacity() {
            return this;
        }
    }
}

