package io.snice.codecs.codec.gtp.gtpc.v2.tliv;

import io.snice.buffer.Buffer;
import io.snice.buffer.Buffers;
import io.snice.codecs.codec.gtp.gtpc.v2.tliv.TypeLengthInstanceValue;
import io.snice.codecs.codec.gtp.gtpc.v2.tliv.impl.BaseTliv;
import io.snice.codecs.codec.gtp.gtpc.v2.tliv.impl.RawTypeLengthInstanceValue;
import io.snice.codecs.codec.gtp.gtpc.v2.type.CounterType;
import io.snice.codecs.codec.gtp.gtpc.v2.Gtp2InfoElement;

import static io.snice.preconditions.PreConditions.assertArgument;
import static io.snice.preconditions.PreConditions.assertNotNull;

/**
 * This file has been auto generated. Do not manually edit.
 * Please see the readme file in the codegen directory
 * for how to update and generate this file.
 *
 * @author jonas@jonasborjesson.com
 */
public interface ApnRestriction extends TypeLengthInstanceValue<CounterType> {

    Gtp2InfoElement TYPE = Gtp2InfoElement.APN_RESTRICTION;

    /**
     * The raw byte value of the Info Element. Useful when writing switch statements
     * since those needs a constant value.
     */
    int TYPE_VALUE = 127;

    static ApnRestriction frame(final Buffer buffer) {
        final var raw = RawTypeLengthInstanceValue.frame(buffer);
        return frame(raw);
    }

    static ApnRestriction frame(final RawTypeLengthInstanceValue raw) {
        assertNotNull(raw);
        assertArgument(raw.getType() == ApnRestriction.TYPE.getType(), "The given raw TLIV is not an APN_RESTRICTION");
        final var value = CounterType.parse(raw.getValue().getBuffer());
        return new DefaultApnRestriction(value, raw);
    }

    static ApnRestriction ofValue(final Buffer buffer) {
        final var value = CounterType.ofValue(buffer);
        return ofValue(value);
    }

    static ApnRestriction ofValue(final Buffer buffer, final int instance) {
        final var value = CounterType.ofValue(buffer);
        return ofValue(value, instance);
    }

    static ApnRestriction ofValue(final String buffer) {
        final var value = CounterType.ofValue(buffer);
        return ofValue(value);
    }

    static ApnRestriction ofValue(final String buffer, final int instance) {
        final var value = CounterType.ofValue(buffer);
        return ofValue(value, instance);
    }

    static ApnRestriction ofValue(final CounterType value) {
        return ofValue(value, 0);
    }

    static ApnRestriction ofValue(final CounterType value, final int instance) {
        final var raw = RawTypeLengthInstanceValue.create(TYPE, instance, value);
        return new DefaultApnRestriction(value, raw);
    }

    @Override
    default ApnRestriction ensure() {
        return this;
    }

    class DefaultApnRestriction extends BaseTliv<CounterType> implements ApnRestriction {
        private DefaultApnRestriction(CounterType value, RawTypeLengthInstanceValue raw) {
            super(value, raw);
        }

        public boolean isApnRestriction() {
            return true;
        }

        public ApnRestriction toApnRestriction() {
            return this;
        }
    }
}

