package io.snice.codecs.codec.gtp.gtpc.v2.tliv;

import io.snice.buffer.Buffer;
import io.snice.buffer.Buffers;
import io.snice.codecs.codec.gtp.gtpc.v2.tliv.TypeLengthInstanceValue;
import io.snice.codecs.codec.gtp.gtpc.v2.tliv.impl.BaseTliv;
import io.snice.codecs.codec.gtp.gtpc.v2.tliv.impl.RawTypeLengthInstanceValue;
import io.snice.codecs.codec.gtp.gtpc.v2.type.GroupedType;
import io.snice.codecs.codec.gtp.gtpc.v2.Gtp2InfoElement;

import static io.snice.preconditions.PreConditions.assertArgument;
import static io.snice.preconditions.PreConditions.assertNotNull;

/**
 * This file has been auto generated. Do not manually edit.
 * Please see the readme file in the codegen directory
 * for how to update and generate this file.
 *
 * @author jonas@jonasborjesson.com
 */
public interface BearerContext extends TypeLengthInstanceValue<GroupedType> {

    Gtp2InfoElement TYPE = Gtp2InfoElement.BEARER_CONTEXT;

    /**
     * The raw byte value of the Info Element. Useful when writing switch statements
     * since those needs a constant value.
     */
    int TYPE_VALUE = 93;

    static BearerContext frame(final Buffer buffer) {
        final var raw = RawTypeLengthInstanceValue.frame(buffer);
        return frame(raw);
    }

    static BearerContext frame(final RawTypeLengthInstanceValue raw) {
        assertNotNull(raw);
        assertArgument(raw.getType() == BearerContext.TYPE.getType(), "The given raw TLIV is not an BEARER_CONTEXT");
        final var value = GroupedType.parse(raw.getValue().getBuffer());
        return new DefaultBearerContext(value, raw);
    }

    static BearerContext ofValue(final Buffer buffer) {
        final var value = GroupedType.ofValue(buffer);
        return ofValue(value);
    }

    static BearerContext ofValue(final Buffer buffer, final int instance) {
        final var value = GroupedType.ofValue(buffer);
        return ofValue(value, instance);
    }

    static BearerContext ofValue(final String buffer) {
        final var value = GroupedType.ofValue(buffer);
        return ofValue(value);
    }

    static BearerContext ofValue(final String buffer, final int instance) {
        final var value = GroupedType.ofValue(buffer);
        return ofValue(value, instance);
    }

    static BearerContext ofValue(final GroupedType value) {
        return ofValue(value, 0);
    }

    static BearerContext ofValue(final GroupedType value, final int instance) {
        final var raw = RawTypeLengthInstanceValue.create(TYPE, instance, value);
        return new DefaultBearerContext(value, raw);
    }

    @Override
    default BearerContext ensure() {
        return this;
    }

    class DefaultBearerContext extends BaseTliv<GroupedType> implements BearerContext {
        private DefaultBearerContext(GroupedType value, RawTypeLengthInstanceValue raw) {
            super(value, raw);
        }

        public boolean isBearerContext() {
            return true;
        }

        public BearerContext toBearerContext() {
            return this;
        }
    }
}

