package io.snice.codecs.codec.gtp.gtpc.v2.tliv;

import io.snice.buffer.Buffer;
import io.snice.buffer.Buffers;
import io.snice.codecs.codec.gtp.gtpc.v2.tliv.TypeLengthInstanceValue;
import io.snice.codecs.codec.gtp.gtpc.v2.tliv.impl.BaseTliv;
import io.snice.codecs.codec.gtp.gtpc.v2.tliv.impl.RawTypeLengthInstanceValue;
import io.snice.codecs.codec.gtp.gtpc.v2.type.BearerQosType;
import io.snice.codecs.codec.gtp.gtpc.v2.Gtp2InfoElement;

import static io.snice.preconditions.PreConditions.assertArgument;
import static io.snice.preconditions.PreConditions.assertNotNull;

/**
 * This file has been auto generated. Do not manually edit.
 * Please see the readme file in the codegen directory
 * for how to update and generate this file.
 *
 * @author jonas@jonasborjesson.com
 */
public interface BearerQos extends TypeLengthInstanceValue<BearerQosType> {

    Gtp2InfoElement TYPE = Gtp2InfoElement.BEARER_QOS;

    /**
     * The raw byte value of the Info Element. Useful when writing switch statements
     * since those needs a constant value.
     */
    int TYPE_VALUE = 80;

    static BearerQos frame(final Buffer buffer) {
        final var raw = RawTypeLengthInstanceValue.frame(buffer);
        return frame(raw);
    }

    static BearerQos frame(final RawTypeLengthInstanceValue raw) {
        assertNotNull(raw);
        assertArgument(raw.getType() == BearerQos.TYPE.getType(), "The given raw TLIV is not an BEARER_QOS");
        final var value = BearerQosType.parse(raw.getValue().getBuffer());
        return new DefaultBearerQos(value, raw);
    }

    static BearerQos ofValue(final Buffer buffer) {
        final var value = BearerQosType.ofValue(buffer);
        return ofValue(value);
    }

    static BearerQos ofValue(final Buffer buffer, final int instance) {
        final var value = BearerQosType.ofValue(buffer);
        return ofValue(value, instance);
    }

    static BearerQos ofValue(final String buffer) {
        final var value = BearerQosType.ofValue(buffer);
        return ofValue(value);
    }

    static BearerQos ofValue(final String buffer, final int instance) {
        final var value = BearerQosType.ofValue(buffer);
        return ofValue(value, instance);
    }

    static BearerQos ofValue(final BearerQosType value) {
        return ofValue(value, 0);
    }

    static BearerQos ofValue(final BearerQosType value, final int instance) {
        final var raw = RawTypeLengthInstanceValue.create(TYPE, instance, value);
        return new DefaultBearerQos(value, raw);
    }

    @Override
    default BearerQos ensure() {
        return this;
    }

    class DefaultBearerQos extends BaseTliv<BearerQosType> implements BearerQos {
        private DefaultBearerQos(BearerQosType value, RawTypeLengthInstanceValue raw) {
            super(value, raw);
        }

        public boolean isBearerQos() {
            return true;
        }

        public BearerQos toBearerQos() {
            return this;
        }
    }
}

