package io.snice.codecs.codec.gtp.gtpc.v2.tliv;

import io.snice.buffer.Buffer;
import io.snice.buffer.Buffers;
import io.snice.codecs.codec.gtp.gtpc.v2.tliv.TypeLengthInstanceValue;
import io.snice.codecs.codec.gtp.gtpc.v2.tliv.impl.BaseTliv;
import io.snice.codecs.codec.gtp.gtpc.v2.tliv.impl.RawTypeLengthInstanceValue;
import io.snice.codecs.codec.gtp.gtpc.v2.type.CauseType;
import io.snice.codecs.codec.gtp.gtpc.v2.Gtp2InfoElement;

import static io.snice.preconditions.PreConditions.assertArgument;
import static io.snice.preconditions.PreConditions.assertNotNull;

/**
 * This file has been auto generated. Do not manually edit.
 * Please see the readme file in the codegen directory
 * for how to update and generate this file.
 *
 * @author jonas@jonasborjesson.com
 */
public interface Cause extends TypeLengthInstanceValue<CauseType> {

    Gtp2InfoElement TYPE = Gtp2InfoElement.CAUSE;

    /**
     * The raw byte value of the Info Element. Useful when writing switch statements
     * since those needs a constant value.
     */
    int TYPE_VALUE = 2;

    static Cause frame(final Buffer buffer) {
        final var raw = RawTypeLengthInstanceValue.frame(buffer);
        return frame(raw);
    }

    static Cause frame(final RawTypeLengthInstanceValue raw) {
        assertNotNull(raw);
        assertArgument(raw.getType() == Cause.TYPE.getType(), "The given raw TLIV is not an CAUSE");
        final var value = CauseType.parse(raw.getValue().getBuffer());
        return new DefaultCause(value, raw);
    }

    static Cause ofValue(final Buffer buffer) {
        final var value = CauseType.ofValue(buffer);
        return ofValue(value);
    }

    static Cause ofValue(final Buffer buffer, final int instance) {
        final var value = CauseType.ofValue(buffer);
        return ofValue(value, instance);
    }

    static Cause ofValue(final String buffer) {
        final var value = CauseType.ofValue(buffer);
        return ofValue(value);
    }

    static Cause ofValue(final String buffer, final int instance) {
        final var value = CauseType.ofValue(buffer);
        return ofValue(value, instance);
    }

    static Cause ofValue(final CauseType value) {
        return ofValue(value, 0);
    }

    static Cause ofValue(final CauseType value, final int instance) {
        final var raw = RawTypeLengthInstanceValue.create(TYPE, instance, value);
        return new DefaultCause(value, raw);
    }

    @Override
    default Cause ensure() {
        return this;
    }

    class DefaultCause extends BaseTliv<CauseType> implements Cause {
        private DefaultCause(CauseType value, RawTypeLengthInstanceValue raw) {
            super(value, raw);
        }

        public boolean isCause() {
            return true;
        }

        public Cause toCause() {
            return this;
        }
    }
}

