package io.snice.codecs.codec.gtp.gtpc.v2.tliv;

import io.snice.buffer.Buffer;
import io.snice.buffer.Buffers;
import io.snice.codecs.codec.gtp.gtpc.v2.tliv.TypeLengthInstanceValue;
import io.snice.codecs.codec.gtp.gtpc.v2.tliv.impl.BaseTliv;
import io.snice.codecs.codec.gtp.gtpc.v2.tliv.impl.RawTypeLengthInstanceValue;
import io.snice.codecs.codec.gtp.gtpc.v2.type.RawType;
import io.snice.codecs.codec.gtp.gtpc.v2.Gtp2InfoElement;

import static io.snice.preconditions.PreConditions.assertArgument;
import static io.snice.preconditions.PreConditions.assertNotNull;

/**
 * This file has been auto generated. Do not manually edit.
 * Please see the readme file in the codegen directory
 * for how to update and generate this file.
 *
 * @author jonas@jonasborjesson.com
 */
public interface ChangeToReportFlags extends TypeLengthInstanceValue<RawType> {

    Gtp2InfoElement TYPE = Gtp2InfoElement.CHANGE_TO_REPORT_FLAGS;

    /**
     * The raw byte value of the Info Element. Useful when writing switch statements
     * since those needs a constant value.
     */
    int TYPE_VALUE = 167;

    static ChangeToReportFlags frame(final Buffer buffer) {
        final var raw = RawTypeLengthInstanceValue.frame(buffer);
        return frame(raw);
    }

    static ChangeToReportFlags frame(final RawTypeLengthInstanceValue raw) {
        assertNotNull(raw);
        assertArgument(raw.getType() == ChangeToReportFlags.TYPE.getType(), "The given raw TLIV is not an CHANGE_TO_REPORT_FLAGS");
        final var value = RawType.parse(raw.getValue().getBuffer());
        return new DefaultChangeToReportFlags(value, raw);
    }

    static ChangeToReportFlags ofValue(final Buffer buffer) {
        final var value = RawType.ofValue(buffer);
        return ofValue(value);
    }

    static ChangeToReportFlags ofValue(final Buffer buffer, final int instance) {
        final var value = RawType.ofValue(buffer);
        return ofValue(value, instance);
    }

    static ChangeToReportFlags ofValue(final String buffer) {
        final var value = RawType.ofValue(buffer);
        return ofValue(value);
    }

    static ChangeToReportFlags ofValue(final String buffer, final int instance) {
        final var value = RawType.ofValue(buffer);
        return ofValue(value, instance);
    }

    static ChangeToReportFlags ofValue(final RawType value) {
        return ofValue(value, 0);
    }

    static ChangeToReportFlags ofValue(final RawType value, final int instance) {
        final var raw = RawTypeLengthInstanceValue.create(TYPE, instance, value);
        return new DefaultChangeToReportFlags(value, raw);
    }

    @Override
    default ChangeToReportFlags ensure() {
        return this;
    }

    class DefaultChangeToReportFlags extends BaseTliv<RawType> implements ChangeToReportFlags {
        private DefaultChangeToReportFlags(RawType value, RawTypeLengthInstanceValue raw) {
            super(value, raw);
        }

        public boolean isChangeToReportFlags() {
            return true;
        }

        public ChangeToReportFlags toChangeToReportFlags() {
            return this;
        }
    }
}

