package io.snice.codecs.codec.gtp.gtpc.v2.tliv;

import io.snice.buffer.Buffer;
import io.snice.buffer.Buffers;
import io.snice.codecs.codec.gtp.gtpc.v2.tliv.TypeLengthInstanceValue;
import io.snice.codecs.codec.gtp.gtpc.v2.tliv.impl.BaseTliv;
import io.snice.codecs.codec.gtp.gtpc.v2.tliv.impl.RawTypeLengthInstanceValue;
import io.snice.codecs.codec.gtp.gtpc.v2.type.RawType;
import io.snice.codecs.codec.gtp.gtpc.v2.Gtp2InfoElement;

import static io.snice.preconditions.PreConditions.assertArgument;
import static io.snice.preconditions.PreConditions.assertNotNull;

/**
 * This file has been auto generated. Do not manually edit.
 * Please see the readme file in the codegen directory
 * for how to update and generate this file.
 *
 * @author jonas@jonasborjesson.com
 */
public interface CsgInformationReportingAction extends TypeLengthInstanceValue<RawType> {

    Gtp2InfoElement TYPE = Gtp2InfoElement.CSG_INFORMATION_REPORTING_ACTION;

    /**
     * The raw byte value of the Info Element. Useful when writing switch statements
     * since those needs a constant value.
     */
    int TYPE_VALUE = 146;

    static CsgInformationReportingAction frame(final Buffer buffer) {
        final var raw = RawTypeLengthInstanceValue.frame(buffer);
        return frame(raw);
    }

    static CsgInformationReportingAction frame(final RawTypeLengthInstanceValue raw) {
        assertNotNull(raw);
        assertArgument(raw.getType() == CsgInformationReportingAction.TYPE.getType(), "The given raw TLIV is not an CSG_INFORMATION_REPORTING_ACTION");
        final var value = RawType.parse(raw.getValue().getBuffer());
        return new DefaultCsgInformationReportingAction(value, raw);
    }

    static CsgInformationReportingAction ofValue(final Buffer buffer) {
        final var value = RawType.ofValue(buffer);
        return ofValue(value);
    }

    static CsgInformationReportingAction ofValue(final Buffer buffer, final int instance) {
        final var value = RawType.ofValue(buffer);
        return ofValue(value, instance);
    }

    static CsgInformationReportingAction ofValue(final String buffer) {
        final var value = RawType.ofValue(buffer);
        return ofValue(value);
    }

    static CsgInformationReportingAction ofValue(final String buffer, final int instance) {
        final var value = RawType.ofValue(buffer);
        return ofValue(value, instance);
    }

    static CsgInformationReportingAction ofValue(final RawType value) {
        return ofValue(value, 0);
    }

    static CsgInformationReportingAction ofValue(final RawType value, final int instance) {
        final var raw = RawTypeLengthInstanceValue.create(TYPE, instance, value);
        return new DefaultCsgInformationReportingAction(value, raw);
    }

    @Override
    default CsgInformationReportingAction ensure() {
        return this;
    }

    class DefaultCsgInformationReportingAction extends BaseTliv<RawType> implements CsgInformationReportingAction {
        private DefaultCsgInformationReportingAction(RawType value, RawTypeLengthInstanceValue raw) {
            super(value, raw);
        }

        public boolean isCsgInformationReportingAction() {
            return true;
        }

        public CsgInformationReportingAction toCsgInformationReportingAction() {
            return this;
        }
    }
}

