package io.snice.codecs.codec.gtp.gtpc.v2.tliv;

import io.snice.buffer.Buffer;
import io.snice.buffer.Buffers;
import io.snice.codecs.codec.gtp.gtpc.v2.tliv.TypeLengthInstanceValue;
import io.snice.codecs.codec.gtp.gtpc.v2.tliv.impl.BaseTliv;
import io.snice.codecs.codec.gtp.gtpc.v2.tliv.impl.RawTypeLengthInstanceValue;
import io.snice.codecs.codec.gtp.gtpc.v2.type.EbiType;
import io.snice.codecs.codec.gtp.gtpc.v2.Gtp2InfoElement;

import static io.snice.preconditions.PreConditions.assertArgument;
import static io.snice.preconditions.PreConditions.assertNotNull;

/**
 * This file has been auto generated. Do not manually edit.
 * Please see the readme file in the codegen directory
 * for how to update and generate this file.
 *
 * @author jonas@jonasborjesson.com
 */
public interface Ebi extends TypeLengthInstanceValue<EbiType> {

    Gtp2InfoElement TYPE = Gtp2InfoElement.EBI;

    /**
     * The raw byte value of the Info Element. Useful when writing switch statements
     * since those needs a constant value.
     */
    int TYPE_VALUE = 73;

    static Ebi frame(final Buffer buffer) {
        final var raw = RawTypeLengthInstanceValue.frame(buffer);
        return frame(raw);
    }

    static Ebi frame(final RawTypeLengthInstanceValue raw) {
        assertNotNull(raw);
        assertArgument(raw.getType() == Ebi.TYPE.getType(), "The given raw TLIV is not an EBI");
        final var value = EbiType.parse(raw.getValue().getBuffer());
        return new DefaultEbi(value, raw);
    }

    static Ebi ofValue(final Buffer buffer) {
        final var value = EbiType.ofValue(buffer);
        return ofValue(value);
    }

    static Ebi ofValue(final Buffer buffer, final int instance) {
        final var value = EbiType.ofValue(buffer);
        return ofValue(value, instance);
    }

    static Ebi ofValue(final String buffer) {
        final var value = EbiType.ofValue(buffer);
        return ofValue(value);
    }

    static Ebi ofValue(final String buffer, final int instance) {
        final var value = EbiType.ofValue(buffer);
        return ofValue(value, instance);
    }

    static Ebi ofValue(final EbiType value) {
        return ofValue(value, 0);
    }

    static Ebi ofValue(final EbiType value, final int instance) {
        final var raw = RawTypeLengthInstanceValue.create(TYPE, instance, value);
        return new DefaultEbi(value, raw);
    }

    @Override
    default Ebi ensure() {
        return this;
    }

    class DefaultEbi extends BaseTliv<EbiType> implements Ebi {
        private DefaultEbi(EbiType value, RawTypeLengthInstanceValue raw) {
            super(value, raw);
        }

        public boolean isEbi() {
            return true;
        }

        public Ebi toEbi() {
            return this;
        }
    }
}

