package io.snice.codecs.codec.gtp.gtpc.v2.tliv;

import io.snice.buffer.Buffer;
import io.snice.buffer.Buffers;
import io.snice.codecs.codec.gtp.gtpc.v2.tliv.TypeLengthInstanceValue;
import io.snice.codecs.codec.gtp.gtpc.v2.tliv.impl.BaseTliv;
import io.snice.codecs.codec.gtp.gtpc.v2.tliv.impl.RawTypeLengthInstanceValue;
import io.snice.codecs.codec.gtp.gtpc.v2.type.FTeidType;
import io.snice.codecs.codec.gtp.gtpc.v2.Gtp2InfoElement;

import static io.snice.preconditions.PreConditions.assertArgument;
import static io.snice.preconditions.PreConditions.assertNotNull;

/**
 * This file has been auto generated. Do not manually edit.
 * Please see the readme file in the codegen directory
 * for how to update and generate this file.
 *
 * @author jonas@jonasborjesson.com
 */
public interface FTeid extends TypeLengthInstanceValue<FTeidType> {

    Gtp2InfoElement TYPE = Gtp2InfoElement.F_TEID;

    /**
     * The raw byte value of the Info Element. Useful when writing switch statements
     * since those needs a constant value.
     */
    int TYPE_VALUE = 87;

    static FTeid frame(final Buffer buffer) {
        final var raw = RawTypeLengthInstanceValue.frame(buffer);
        return frame(raw);
    }

    static FTeid frame(final RawTypeLengthInstanceValue raw) {
        assertNotNull(raw);
        assertArgument(raw.getType() == FTeid.TYPE.getType(), "The given raw TLIV is not an F_TEID");
        final var value = FTeidType.parse(raw.getValue().getBuffer());
        return new DefaultFTeid(value, raw);
    }

    static FTeid ofValue(final Buffer buffer) {
        final var value = FTeidType.ofValue(buffer);
        return ofValue(value);
    }

    static FTeid ofValue(final Buffer buffer, final int instance) {
        final var value = FTeidType.ofValue(buffer);
        return ofValue(value, instance);
    }

    static FTeid ofValue(final String buffer) {
        final var value = FTeidType.ofValue(buffer);
        return ofValue(value);
    }

    static FTeid ofValue(final String buffer, final int instance) {
        final var value = FTeidType.ofValue(buffer);
        return ofValue(value, instance);
    }

    static FTeid ofValue(final FTeidType value) {
        return ofValue(value, 0);
    }

    static FTeid ofValue(final FTeidType value, final int instance) {
        final var raw = RawTypeLengthInstanceValue.create(TYPE, instance, value);
        return new DefaultFTeid(value, raw);
    }

    @Override
    default FTeid ensure() {
        return this;
    }

    class DefaultFTeid extends BaseTliv<FTeidType> implements FTeid {
        private DefaultFTeid(FTeidType value, RawTypeLengthInstanceValue raw) {
            super(value, raw);
        }

        public boolean isFTeid() {
            return true;
        }

        public FTeid toFTeid() {
            return this;
        }
    }
}

