package io.snice.codecs.codec.gtp.gtpc.v2.tliv;

import io.snice.buffer.Buffer;
import io.snice.buffer.Buffers;
import io.snice.codecs.codec.gtp.gtpc.v2.tliv.TypeLengthInstanceValue;
import io.snice.codecs.codec.gtp.gtpc.v2.tliv.impl.BaseTliv;
import io.snice.codecs.codec.gtp.gtpc.v2.tliv.impl.RawTypeLengthInstanceValue;
import io.snice.codecs.codec.gtp.gtpc.v2.type.QosType;
import io.snice.codecs.codec.gtp.gtpc.v2.Gtp2InfoElement;

import static io.snice.preconditions.PreConditions.assertArgument;
import static io.snice.preconditions.PreConditions.assertNotNull;

/**
 * This file has been auto generated. Do not manually edit.
 * Please see the readme file in the codegen directory
 * for how to update and generate this file.
 *
 * @author jonas@jonasborjesson.com
 */
public interface FlowQos extends TypeLengthInstanceValue<QosType> {

    Gtp2InfoElement TYPE = Gtp2InfoElement.FLOW_QOS;

    /**
     * The raw byte value of the Info Element. Useful when writing switch statements
     * since those needs a constant value.
     */
    int TYPE_VALUE = 81;

    static FlowQos frame(final Buffer buffer) {
        final var raw = RawTypeLengthInstanceValue.frame(buffer);
        return frame(raw);
    }

    static FlowQos frame(final RawTypeLengthInstanceValue raw) {
        assertNotNull(raw);
        assertArgument(raw.getType() == FlowQos.TYPE.getType(), "The given raw TLIV is not an FLOW_QOS");
        final var value = QosType.parse(raw.getValue().getBuffer());
        return new DefaultFlowQos(value, raw);
    }

    static FlowQos ofValue(final Buffer buffer) {
        final var value = QosType.ofValue(buffer);
        return ofValue(value);
    }

    static FlowQos ofValue(final Buffer buffer, final int instance) {
        final var value = QosType.ofValue(buffer);
        return ofValue(value, instance);
    }

    static FlowQos ofValue(final String buffer) {
        final var value = QosType.ofValue(buffer);
        return ofValue(value);
    }

    static FlowQos ofValue(final String buffer, final int instance) {
        final var value = QosType.ofValue(buffer);
        return ofValue(value, instance);
    }

    static FlowQos ofValue(final QosType value) {
        return ofValue(value, 0);
    }

    static FlowQos ofValue(final QosType value, final int instance) {
        final var raw = RawTypeLengthInstanceValue.create(TYPE, instance, value);
        return new DefaultFlowQos(value, raw);
    }

    @Override
    default FlowQos ensure() {
        return this;
    }

    class DefaultFlowQos extends BaseTliv<QosType> implements FlowQos {
        private DefaultFlowQos(QosType value, RawTypeLengthInstanceValue raw) {
            super(value, raw);
        }

        public boolean isFlowQos() {
            return true;
        }

        public FlowQos toFlowQos() {
            return this;
        }
    }
}

