package io.snice.codecs.codec.gtp.gtpc.v2.tliv;

import io.snice.buffer.Buffer;
import io.snice.buffer.Buffers;
import io.snice.codecs.codec.gtp.gtpc.v2.tliv.TypeLengthInstanceValue;
import io.snice.codecs.codec.gtp.gtpc.v2.tliv.impl.BaseTliv;
import io.snice.codecs.codec.gtp.gtpc.v2.tliv.impl.RawTypeLengthInstanceValue;
import io.snice.codecs.codec.gtp.gtpc.v2.type.RawType;
import io.snice.codecs.codec.gtp.gtpc.v2.Gtp2InfoElement;

import static io.snice.preconditions.PreConditions.assertArgument;
import static io.snice.preconditions.PreConditions.assertNotNull;

/**
 * This file has been auto generated. Do not manually edit.
 * Please see the readme file in the codegen directory
 * for how to update and generate this file.
 *
 * @author jonas@jonasborjesson.com
 */
public interface GlobalCnId extends TypeLengthInstanceValue<RawType> {

    Gtp2InfoElement TYPE = Gtp2InfoElement.GLOBAL_CN_ID;

    /**
     * The raw byte value of the Info Element. Useful when writing switch statements
     * since those needs a constant value.
     */
    int TYPE_VALUE = 89;

    static GlobalCnId frame(final Buffer buffer) {
        final var raw = RawTypeLengthInstanceValue.frame(buffer);
        return frame(raw);
    }

    static GlobalCnId frame(final RawTypeLengthInstanceValue raw) {
        assertNotNull(raw);
        assertArgument(raw.getType() == GlobalCnId.TYPE.getType(), "The given raw TLIV is not an GLOBAL_CN_ID");
        final var value = RawType.parse(raw.getValue().getBuffer());
        return new DefaultGlobalCnId(value, raw);
    }

    static GlobalCnId ofValue(final Buffer buffer) {
        final var value = RawType.ofValue(buffer);
        return ofValue(value);
    }

    static GlobalCnId ofValue(final Buffer buffer, final int instance) {
        final var value = RawType.ofValue(buffer);
        return ofValue(value, instance);
    }

    static GlobalCnId ofValue(final String buffer) {
        final var value = RawType.ofValue(buffer);
        return ofValue(value);
    }

    static GlobalCnId ofValue(final String buffer, final int instance) {
        final var value = RawType.ofValue(buffer);
        return ofValue(value, instance);
    }

    static GlobalCnId ofValue(final RawType value) {
        return ofValue(value, 0);
    }

    static GlobalCnId ofValue(final RawType value, final int instance) {
        final var raw = RawTypeLengthInstanceValue.create(TYPE, instance, value);
        return new DefaultGlobalCnId(value, raw);
    }

    @Override
    default GlobalCnId ensure() {
        return this;
    }

    class DefaultGlobalCnId extends BaseTliv<RawType> implements GlobalCnId {
        private DefaultGlobalCnId(RawType value, RawTypeLengthInstanceValue raw) {
            super(value, raw);
        }

        public boolean isGlobalCnId() {
            return true;
        }

        public GlobalCnId toGlobalCnId() {
            return this;
        }
    }
}

