package io.snice.codecs.codec.gtp.gtpc.v2.tliv;

import io.snice.buffer.Buffer;
import io.snice.buffer.Buffers;
import io.snice.codecs.codec.gtp.gtpc.v2.tliv.TypeLengthInstanceValue;
import io.snice.codecs.codec.gtp.gtpc.v2.tliv.impl.BaseTliv;
import io.snice.codecs.codec.gtp.gtpc.v2.tliv.impl.RawTypeLengthInstanceValue;
import io.snice.codecs.codec.gtp.gtpc.v2.type.RawType;
import io.snice.codecs.codec.gtp.gtpc.v2.Gtp2InfoElement;

import static io.snice.preconditions.PreConditions.assertArgument;
import static io.snice.preconditions.PreConditions.assertNotNull;

/**
 * This file has been auto generated. Do not manually edit.
 * Please see the readme file in the codegen directory
 * for how to update and generate this file.
 *
 * @author jonas@jonasborjesson.com
 */
public interface HeaderCompressionConfiguration extends TypeLengthInstanceValue<RawType> {

    Gtp2InfoElement TYPE = Gtp2InfoElement.HEADER_COMPRESSION_CONFIGURATION;

    /**
     * The raw byte value of the Info Element. Useful when writing switch statements
     * since those needs a constant value.
     */
    int TYPE_VALUE = 196;

    static HeaderCompressionConfiguration frame(final Buffer buffer) {
        final var raw = RawTypeLengthInstanceValue.frame(buffer);
        return frame(raw);
    }

    static HeaderCompressionConfiguration frame(final RawTypeLengthInstanceValue raw) {
        assertNotNull(raw);
        assertArgument(raw.getType() == HeaderCompressionConfiguration.TYPE.getType(), "The given raw TLIV is not an HEADER_COMPRESSION_CONFIGURATION");
        final var value = RawType.parse(raw.getValue().getBuffer());
        return new DefaultHeaderCompressionConfiguration(value, raw);
    }

    static HeaderCompressionConfiguration ofValue(final Buffer buffer) {
        final var value = RawType.ofValue(buffer);
        return ofValue(value);
    }

    static HeaderCompressionConfiguration ofValue(final Buffer buffer, final int instance) {
        final var value = RawType.ofValue(buffer);
        return ofValue(value, instance);
    }

    static HeaderCompressionConfiguration ofValue(final String buffer) {
        final var value = RawType.ofValue(buffer);
        return ofValue(value);
    }

    static HeaderCompressionConfiguration ofValue(final String buffer, final int instance) {
        final var value = RawType.ofValue(buffer);
        return ofValue(value, instance);
    }

    static HeaderCompressionConfiguration ofValue(final RawType value) {
        return ofValue(value, 0);
    }

    static HeaderCompressionConfiguration ofValue(final RawType value, final int instance) {
        final var raw = RawTypeLengthInstanceValue.create(TYPE, instance, value);
        return new DefaultHeaderCompressionConfiguration(value, raw);
    }

    @Override
    default HeaderCompressionConfiguration ensure() {
        return this;
    }

    class DefaultHeaderCompressionConfiguration extends BaseTliv<RawType> implements HeaderCompressionConfiguration {
        private DefaultHeaderCompressionConfiguration(RawType value, RawTypeLengthInstanceValue raw) {
            super(value, raw);
        }

        public boolean isHeaderCompressionConfiguration() {
            return true;
        }

        public HeaderCompressionConfiguration toHeaderCompressionConfiguration() {
            return this;
        }
    }
}

