package io.snice.codecs.codec.gtp.gtpc.v2.tliv;

import io.snice.buffer.Buffer;
import io.snice.buffer.Buffers;
import io.snice.codecs.codec.gtp.gtpc.v2.tliv.TypeLengthInstanceValue;
import io.snice.codecs.codec.gtp.gtpc.v2.tliv.impl.BaseTliv;
import io.snice.codecs.codec.gtp.gtpc.v2.tliv.impl.RawTypeLengthInstanceValue;
import io.snice.codecs.codec.gtp.gtpc.v2.type.TbcdType;
import io.snice.codecs.codec.gtp.gtpc.v2.Gtp2InfoElement;

import static io.snice.preconditions.PreConditions.assertArgument;
import static io.snice.preconditions.PreConditions.assertNotNull;

/**
 * This file has been auto generated. Do not manually edit.
 * Please see the readme file in the codegen directory
 * for how to update and generate this file.
 *
 * @author jonas@jonasborjesson.com
 */
public interface Imsi extends TypeLengthInstanceValue<TbcdType> {

    Gtp2InfoElement TYPE = Gtp2InfoElement.IMSI;

    /**
     * The raw byte value of the Info Element. Useful when writing switch statements
     * since those needs a constant value.
     */
    int TYPE_VALUE = 1;

    static Imsi frame(final Buffer buffer) {
        final var raw = RawTypeLengthInstanceValue.frame(buffer);
        return frame(raw);
    }

    static Imsi frame(final RawTypeLengthInstanceValue raw) {
        assertNotNull(raw);
        assertArgument(raw.getType() == Imsi.TYPE.getType(), "The given raw TLIV is not an IMSI");
        final var value = TbcdType.parse(raw.getValue().getBuffer());
        return new DefaultImsi(value, raw);
    }

    static Imsi ofValue(final Buffer buffer) {
        final var value = TbcdType.ofValue(buffer);
        return ofValue(value);
    }

    static Imsi ofValue(final Buffer buffer, final int instance) {
        final var value = TbcdType.ofValue(buffer);
        return ofValue(value, instance);
    }

    static Imsi ofValue(final String buffer) {
        final var value = TbcdType.ofValue(buffer);
        return ofValue(value);
    }

    static Imsi ofValue(final String buffer, final int instance) {
        final var value = TbcdType.ofValue(buffer);
        return ofValue(value, instance);
    }

    static Imsi ofValue(final TbcdType value) {
        return ofValue(value, 0);
    }

    static Imsi ofValue(final TbcdType value, final int instance) {
        final var raw = RawTypeLengthInstanceValue.create(TYPE, instance, value);
        return new DefaultImsi(value, raw);
    }

    @Override
    default Imsi ensure() {
        return this;
    }

    class DefaultImsi extends BaseTliv<TbcdType> implements Imsi {
        private DefaultImsi(TbcdType value, RawTypeLengthInstanceValue raw) {
            super(value, raw);
        }

        public boolean isImsi() {
            return true;
        }

        public Imsi toImsi() {
            return this;
        }
    }
}

