package io.snice.codecs.codec.gtp.gtpc.v2.tliv;

import io.snice.buffer.Buffer;
import io.snice.buffer.Buffers;
import io.snice.codecs.codec.gtp.gtpc.v2.tliv.TypeLengthInstanceValue;
import io.snice.codecs.codec.gtp.gtpc.v2.tliv.impl.BaseTliv;
import io.snice.codecs.codec.gtp.gtpc.v2.tliv.impl.RawTypeLengthInstanceValue;
import io.snice.codecs.codec.gtp.gtpc.v2.type.RawType;
import io.snice.codecs.codec.gtp.gtpc.v2.Gtp2InfoElement;

import static io.snice.preconditions.PreConditions.assertArgument;
import static io.snice.preconditions.PreConditions.assertNotNull;

/**
 * This file has been auto generated. Do not manually edit.
 * Please see the readme file in the codegen directory
 * for how to update and generate this file.
 *
 * @author jonas@jonasborjesson.com
 */
public interface Indication extends TypeLengthInstanceValue<RawType> {

    Gtp2InfoElement TYPE = Gtp2InfoElement.INDICATION;

    /**
     * The raw byte value of the Info Element. Useful when writing switch statements
     * since those needs a constant value.
     */
    int TYPE_VALUE = 77;

    static Indication frame(final Buffer buffer) {
        final var raw = RawTypeLengthInstanceValue.frame(buffer);
        return frame(raw);
    }

    static Indication frame(final RawTypeLengthInstanceValue raw) {
        assertNotNull(raw);
        assertArgument(raw.getType() == Indication.TYPE.getType(), "The given raw TLIV is not an INDICATION");
        final var value = RawType.parse(raw.getValue().getBuffer());
        return new DefaultIndication(value, raw);
    }

    static Indication ofValue(final Buffer buffer) {
        final var value = RawType.ofValue(buffer);
        return ofValue(value);
    }

    static Indication ofValue(final Buffer buffer, final int instance) {
        final var value = RawType.ofValue(buffer);
        return ofValue(value, instance);
    }

    static Indication ofValue(final String buffer) {
        final var value = RawType.ofValue(buffer);
        return ofValue(value);
    }

    static Indication ofValue(final String buffer, final int instance) {
        final var value = RawType.ofValue(buffer);
        return ofValue(value, instance);
    }

    static Indication ofValue(final RawType value) {
        return ofValue(value, 0);
    }

    static Indication ofValue(final RawType value, final int instance) {
        final var raw = RawTypeLengthInstanceValue.create(TYPE, instance, value);
        return new DefaultIndication(value, raw);
    }

    @Override
    default Indication ensure() {
        return this;
    }

    class DefaultIndication extends BaseTliv<RawType> implements Indication {
        private DefaultIndication(RawType value, RawTypeLengthInstanceValue raw) {
            super(value, raw);
        }

        public boolean isIndication() {
            return true;
        }

        public Indication toIndication() {
            return this;
        }
    }
}

