package io.snice.codecs.codec.gtp.gtpc.v2.tliv;

import io.snice.buffer.Buffer;
import io.snice.buffer.Buffers;
import io.snice.codecs.codec.gtp.gtpc.v2.tliv.TypeLengthInstanceValue;
import io.snice.codecs.codec.gtp.gtpc.v2.tliv.impl.BaseTliv;
import io.snice.codecs.codec.gtp.gtpc.v2.tliv.impl.RawTypeLengthInstanceValue;
import io.snice.codecs.codec.gtp.gtpc.v2.type.RawType;
import io.snice.codecs.codec.gtp.gtpc.v2.Gtp2InfoElement;

import static io.snice.preconditions.PreConditions.assertArgument;
import static io.snice.preconditions.PreConditions.assertNotNull;

/**
 * This file has been auto generated. Do not manually edit.
 * Please see the readme file in the codegen directory
 * for how to update and generate this file.
 *
 * @author jonas@jonasborjesson.com
 */
public interface Ip4cp extends TypeLengthInstanceValue<RawType> {

    Gtp2InfoElement TYPE = Gtp2InfoElement.IP4CP;

    /**
     * The raw byte value of the Info Element. Useful when writing switch statements
     * since those needs a constant value.
     */
    int TYPE_VALUE = 166;

    static Ip4cp frame(final Buffer buffer) {
        final var raw = RawTypeLengthInstanceValue.frame(buffer);
        return frame(raw);
    }

    static Ip4cp frame(final RawTypeLengthInstanceValue raw) {
        assertNotNull(raw);
        assertArgument(raw.getType() == Ip4cp.TYPE.getType(), "The given raw TLIV is not an IP4CP");
        final var value = RawType.parse(raw.getValue().getBuffer());
        return new DefaultIp4cp(value, raw);
    }

    static Ip4cp ofValue(final Buffer buffer) {
        final var value = RawType.ofValue(buffer);
        return ofValue(value);
    }

    static Ip4cp ofValue(final Buffer buffer, final int instance) {
        final var value = RawType.ofValue(buffer);
        return ofValue(value, instance);
    }

    static Ip4cp ofValue(final String buffer) {
        final var value = RawType.ofValue(buffer);
        return ofValue(value);
    }

    static Ip4cp ofValue(final String buffer, final int instance) {
        final var value = RawType.ofValue(buffer);
        return ofValue(value, instance);
    }

    static Ip4cp ofValue(final RawType value) {
        return ofValue(value, 0);
    }

    static Ip4cp ofValue(final RawType value, final int instance) {
        final var raw = RawTypeLengthInstanceValue.create(TYPE, instance, value);
        return new DefaultIp4cp(value, raw);
    }

    @Override
    default Ip4cp ensure() {
        return this;
    }

    class DefaultIp4cp extends BaseTliv<RawType> implements Ip4cp {
        private DefaultIp4cp(RawType value, RawTypeLengthInstanceValue raw) {
            super(value, raw);
        }

        public boolean isIp4cp() {
            return true;
        }

        public Ip4cp toIp4cp() {
            return this;
        }
    }
}

