package io.snice.codecs.codec.gtp.gtpc.v2.tliv;

import io.snice.buffer.Buffer;
import io.snice.buffer.Buffers;
import io.snice.codecs.codec.gtp.gtpc.v2.tliv.TypeLengthInstanceValue;
import io.snice.codecs.codec.gtp.gtpc.v2.tliv.impl.BaseTliv;
import io.snice.codecs.codec.gtp.gtpc.v2.tliv.impl.RawTypeLengthInstanceValue;
import io.snice.codecs.codec.gtp.gtpc.v2.type.RawType;
import io.snice.codecs.codec.gtp.gtpc.v2.Gtp2InfoElement;

import static io.snice.preconditions.PreConditions.assertArgument;
import static io.snice.preconditions.PreConditions.assertNotNull;

/**
 * This file has been auto generated. Do not manually edit.
 * Please see the readme file in the codegen directory
 * for how to update and generate this file.
 *
 * @author jonas@jonasborjesson.com
 */
public interface Ldn extends TypeLengthInstanceValue<RawType> {

    Gtp2InfoElement TYPE = Gtp2InfoElement.LDN;

    /**
     * The raw byte value of the Info Element. Useful when writing switch statements
     * since those needs a constant value.
     */
    int TYPE_VALUE = 151;

    static Ldn frame(final Buffer buffer) {
        final var raw = RawTypeLengthInstanceValue.frame(buffer);
        return frame(raw);
    }

    static Ldn frame(final RawTypeLengthInstanceValue raw) {
        assertNotNull(raw);
        assertArgument(raw.getType() == Ldn.TYPE.getType(), "The given raw TLIV is not an LDN");
        final var value = RawType.parse(raw.getValue().getBuffer());
        return new DefaultLdn(value, raw);
    }

    static Ldn ofValue(final Buffer buffer) {
        final var value = RawType.ofValue(buffer);
        return ofValue(value);
    }

    static Ldn ofValue(final Buffer buffer, final int instance) {
        final var value = RawType.ofValue(buffer);
        return ofValue(value, instance);
    }

    static Ldn ofValue(final String buffer) {
        final var value = RawType.ofValue(buffer);
        return ofValue(value);
    }

    static Ldn ofValue(final String buffer, final int instance) {
        final var value = RawType.ofValue(buffer);
        return ofValue(value, instance);
    }

    static Ldn ofValue(final RawType value) {
        return ofValue(value, 0);
    }

    static Ldn ofValue(final RawType value, final int instance) {
        final var raw = RawTypeLengthInstanceValue.create(TYPE, instance, value);
        return new DefaultLdn(value, raw);
    }

    @Override
    default Ldn ensure() {
        return this;
    }

    class DefaultLdn extends BaseTliv<RawType> implements Ldn {
        private DefaultLdn(RawType value, RawTypeLengthInstanceValue raw) {
            super(value, raw);
        }

        public boolean isLdn() {
            return true;
        }

        public Ldn toLdn() {
            return this;
        }
    }
}

