package io.snice.codecs.codec.gtp.gtpc.v2.tliv;

import io.snice.buffer.Buffer;
import io.snice.buffer.Buffers;
import io.snice.codecs.codec.gtp.gtpc.v2.tliv.TypeLengthInstanceValue;
import io.snice.codecs.codec.gtp.gtpc.v2.tliv.impl.BaseTliv;
import io.snice.codecs.codec.gtp.gtpc.v2.tliv.impl.RawTypeLengthInstanceValue;
import io.snice.codecs.codec.gtp.gtpc.v2.type.RawType;
import io.snice.codecs.codec.gtp.gtpc.v2.Gtp2InfoElement;

import static io.snice.preconditions.PreConditions.assertArgument;
import static io.snice.preconditions.PreConditions.assertNotNull;

/**
 * This file has been auto generated. Do not manually edit.
 * Please see the readme file in the codegen directory
 * for how to update and generate this file.
 *
 * @author jonas@jonasborjesson.com
 */
public interface LoadControlInformation extends TypeLengthInstanceValue<RawType> {

    Gtp2InfoElement TYPE = Gtp2InfoElement.LOAD_CONTROL_INFORMATION;

    /**
     * The raw byte value of the Info Element. Useful when writing switch statements
     * since those needs a constant value.
     */
    int TYPE_VALUE = 181;

    static LoadControlInformation frame(final Buffer buffer) {
        final var raw = RawTypeLengthInstanceValue.frame(buffer);
        return frame(raw);
    }

    static LoadControlInformation frame(final RawTypeLengthInstanceValue raw) {
        assertNotNull(raw);
        assertArgument(raw.getType() == LoadControlInformation.TYPE.getType(), "The given raw TLIV is not an LOAD_CONTROL_INFORMATION");
        final var value = RawType.parse(raw.getValue().getBuffer());
        return new DefaultLoadControlInformation(value, raw);
    }

    static LoadControlInformation ofValue(final Buffer buffer) {
        final var value = RawType.ofValue(buffer);
        return ofValue(value);
    }

    static LoadControlInformation ofValue(final Buffer buffer, final int instance) {
        final var value = RawType.ofValue(buffer);
        return ofValue(value, instance);
    }

    static LoadControlInformation ofValue(final String buffer) {
        final var value = RawType.ofValue(buffer);
        return ofValue(value);
    }

    static LoadControlInformation ofValue(final String buffer, final int instance) {
        final var value = RawType.ofValue(buffer);
        return ofValue(value, instance);
    }

    static LoadControlInformation ofValue(final RawType value) {
        return ofValue(value, 0);
    }

    static LoadControlInformation ofValue(final RawType value, final int instance) {
        final var raw = RawTypeLengthInstanceValue.create(TYPE, instance, value);
        return new DefaultLoadControlInformation(value, raw);
    }

    @Override
    default LoadControlInformation ensure() {
        return this;
    }

    class DefaultLoadControlInformation extends BaseTliv<RawType> implements LoadControlInformation {
        private DefaultLoadControlInformation(RawType value, RawTypeLengthInstanceValue raw) {
            super(value, raw);
        }

        public boolean isLoadControlInformation() {
            return true;
        }

        public LoadControlInformation toLoadControlInformation() {
            return this;
        }
    }
}

