package io.snice.codecs.codec.gtp.gtpc.v2.tliv;

import io.snice.buffer.Buffer;
import io.snice.buffer.Buffers;
import io.snice.codecs.codec.gtp.gtpc.v2.tliv.TypeLengthInstanceValue;
import io.snice.codecs.codec.gtp.gtpc.v2.tliv.impl.BaseTliv;
import io.snice.codecs.codec.gtp.gtpc.v2.tliv.impl.RawTypeLengthInstanceValue;
import io.snice.codecs.codec.gtp.gtpc.v2.type.RawType;
import io.snice.codecs.codec.gtp.gtpc.v2.Gtp2InfoElement;

import static io.snice.preconditions.PreConditions.assertArgument;
import static io.snice.preconditions.PreConditions.assertNotNull;

/**
 * This file has been auto generated. Do not manually edit.
 * Please see the readme file in the codegen directory
 * for how to update and generate this file.
 *
 * @author jonas@jonasborjesson.com
 */
public interface MbmsDistributionAcknowledge extends TypeLengthInstanceValue<RawType> {

    Gtp2InfoElement TYPE = Gtp2InfoElement.MBMS_DISTRIBUTION_ACKNOWLEDGE;

    /**
     * The raw byte value of the Info Element. Useful when writing switch statements
     * since those needs a constant value.
     */
    int TYPE_VALUE = 143;

    static MbmsDistributionAcknowledge frame(final Buffer buffer) {
        final var raw = RawTypeLengthInstanceValue.frame(buffer);
        return frame(raw);
    }

    static MbmsDistributionAcknowledge frame(final RawTypeLengthInstanceValue raw) {
        assertNotNull(raw);
        assertArgument(raw.getType() == MbmsDistributionAcknowledge.TYPE.getType(), "The given raw TLIV is not an MBMS_DISTRIBUTION_ACKNOWLEDGE");
        final var value = RawType.parse(raw.getValue().getBuffer());
        return new DefaultMbmsDistributionAcknowledge(value, raw);
    }

    static MbmsDistributionAcknowledge ofValue(final Buffer buffer) {
        final var value = RawType.ofValue(buffer);
        return ofValue(value);
    }

    static MbmsDistributionAcknowledge ofValue(final Buffer buffer, final int instance) {
        final var value = RawType.ofValue(buffer);
        return ofValue(value, instance);
    }

    static MbmsDistributionAcknowledge ofValue(final String buffer) {
        final var value = RawType.ofValue(buffer);
        return ofValue(value);
    }

    static MbmsDistributionAcknowledge ofValue(final String buffer, final int instance) {
        final var value = RawType.ofValue(buffer);
        return ofValue(value, instance);
    }

    static MbmsDistributionAcknowledge ofValue(final RawType value) {
        return ofValue(value, 0);
    }

    static MbmsDistributionAcknowledge ofValue(final RawType value, final int instance) {
        final var raw = RawTypeLengthInstanceValue.create(TYPE, instance, value);
        return new DefaultMbmsDistributionAcknowledge(value, raw);
    }

    @Override
    default MbmsDistributionAcknowledge ensure() {
        return this;
    }

    class DefaultMbmsDistributionAcknowledge extends BaseTliv<RawType> implements MbmsDistributionAcknowledge {
        private DefaultMbmsDistributionAcknowledge(RawType value, RawTypeLengthInstanceValue raw) {
            super(value, raw);
        }

        public boolean isMbmsDistributionAcknowledge() {
            return true;
        }

        public MbmsDistributionAcknowledge toMbmsDistributionAcknowledge() {
            return this;
        }
    }
}

