package io.snice.codecs.codec.gtp.gtpc.v2.tliv;

import io.snice.buffer.Buffer;
import io.snice.buffer.Buffers;
import io.snice.codecs.codec.gtp.gtpc.v2.tliv.TypeLengthInstanceValue;
import io.snice.codecs.codec.gtp.gtpc.v2.tliv.impl.BaseTliv;
import io.snice.codecs.codec.gtp.gtpc.v2.tliv.impl.RawTypeLengthInstanceValue;
import io.snice.codecs.codec.gtp.gtpc.v2.type.RawType;
import io.snice.codecs.codec.gtp.gtpc.v2.Gtp2InfoElement;

import static io.snice.preconditions.PreConditions.assertArgument;
import static io.snice.preconditions.PreConditions.assertNotNull;

/**
 * This file has been auto generated. Do not manually edit.
 * Please see the readme file in the codegen directory
 * for how to update and generate this file.
 *
 * @author jonas@jonasborjesson.com
 */
public interface MbmsFlowIdentifier extends TypeLengthInstanceValue<RawType> {

    Gtp2InfoElement TYPE = Gtp2InfoElement.MBMS_FLOW_IDENTIFIER;

    /**
     * The raw byte value of the Info Element. Useful when writing switch statements
     * since those needs a constant value.
     */
    int TYPE_VALUE = 141;

    static MbmsFlowIdentifier frame(final Buffer buffer) {
        final var raw = RawTypeLengthInstanceValue.frame(buffer);
        return frame(raw);
    }

    static MbmsFlowIdentifier frame(final RawTypeLengthInstanceValue raw) {
        assertNotNull(raw);
        assertArgument(raw.getType() == MbmsFlowIdentifier.TYPE.getType(), "The given raw TLIV is not an MBMS_FLOW_IDENTIFIER");
        final var value = RawType.parse(raw.getValue().getBuffer());
        return new DefaultMbmsFlowIdentifier(value, raw);
    }

    static MbmsFlowIdentifier ofValue(final Buffer buffer) {
        final var value = RawType.ofValue(buffer);
        return ofValue(value);
    }

    static MbmsFlowIdentifier ofValue(final Buffer buffer, final int instance) {
        final var value = RawType.ofValue(buffer);
        return ofValue(value, instance);
    }

    static MbmsFlowIdentifier ofValue(final String buffer) {
        final var value = RawType.ofValue(buffer);
        return ofValue(value);
    }

    static MbmsFlowIdentifier ofValue(final String buffer, final int instance) {
        final var value = RawType.ofValue(buffer);
        return ofValue(value, instance);
    }

    static MbmsFlowIdentifier ofValue(final RawType value) {
        return ofValue(value, 0);
    }

    static MbmsFlowIdentifier ofValue(final RawType value, final int instance) {
        final var raw = RawTypeLengthInstanceValue.create(TYPE, instance, value);
        return new DefaultMbmsFlowIdentifier(value, raw);
    }

    @Override
    default MbmsFlowIdentifier ensure() {
        return this;
    }

    class DefaultMbmsFlowIdentifier extends BaseTliv<RawType> implements MbmsFlowIdentifier {
        private DefaultMbmsFlowIdentifier(RawType value, RawTypeLengthInstanceValue raw) {
            super(value, raw);
        }

        public boolean isMbmsFlowIdentifier() {
            return true;
        }

        public MbmsFlowIdentifier toMbmsFlowIdentifier() {
            return this;
        }
    }
}

