package io.snice.codecs.codec.gtp.gtpc.v2.tliv;

import io.snice.buffer.Buffer;
import io.snice.buffer.Buffers;
import io.snice.codecs.codec.gtp.gtpc.v2.tliv.TypeLengthInstanceValue;
import io.snice.codecs.codec.gtp.gtpc.v2.tliv.impl.BaseTliv;
import io.snice.codecs.codec.gtp.gtpc.v2.tliv.impl.RawTypeLengthInstanceValue;
import io.snice.codecs.codec.gtp.gtpc.v2.type.RawType;
import io.snice.codecs.codec.gtp.gtpc.v2.Gtp2InfoElement;

import static io.snice.preconditions.PreConditions.assertArgument;
import static io.snice.preconditions.PreConditions.assertNotNull;

/**
 * This file has been auto generated. Do not manually edit.
 * Please see the readme file in the codegen directory
 * for how to update and generate this file.
 *
 * @author jonas@jonasborjesson.com
 */
public interface MbmsSessionDuration extends TypeLengthInstanceValue<RawType> {

    Gtp2InfoElement TYPE = Gtp2InfoElement.MBMS_SESSION_DURATION;

    /**
     * The raw byte value of the Info Element. Useful when writing switch statements
     * since those needs a constant value.
     */
    int TYPE_VALUE = 138;

    static MbmsSessionDuration frame(final Buffer buffer) {
        final var raw = RawTypeLengthInstanceValue.frame(buffer);
        return frame(raw);
    }

    static MbmsSessionDuration frame(final RawTypeLengthInstanceValue raw) {
        assertNotNull(raw);
        assertArgument(raw.getType() == MbmsSessionDuration.TYPE.getType(), "The given raw TLIV is not an MBMS_SESSION_DURATION");
        final var value = RawType.parse(raw.getValue().getBuffer());
        return new DefaultMbmsSessionDuration(value, raw);
    }

    static MbmsSessionDuration ofValue(final Buffer buffer) {
        final var value = RawType.ofValue(buffer);
        return ofValue(value);
    }

    static MbmsSessionDuration ofValue(final Buffer buffer, final int instance) {
        final var value = RawType.ofValue(buffer);
        return ofValue(value, instance);
    }

    static MbmsSessionDuration ofValue(final String buffer) {
        final var value = RawType.ofValue(buffer);
        return ofValue(value);
    }

    static MbmsSessionDuration ofValue(final String buffer, final int instance) {
        final var value = RawType.ofValue(buffer);
        return ofValue(value, instance);
    }

    static MbmsSessionDuration ofValue(final RawType value) {
        return ofValue(value, 0);
    }

    static MbmsSessionDuration ofValue(final RawType value, final int instance) {
        final var raw = RawTypeLengthInstanceValue.create(TYPE, instance, value);
        return new DefaultMbmsSessionDuration(value, raw);
    }

    @Override
    default MbmsSessionDuration ensure() {
        return this;
    }

    class DefaultMbmsSessionDuration extends BaseTliv<RawType> implements MbmsSessionDuration {
        private DefaultMbmsSessionDuration(RawType value, RawTypeLengthInstanceValue raw) {
            super(value, raw);
        }

        public boolean isMbmsSessionDuration() {
            return true;
        }

        public MbmsSessionDuration toMbmsSessionDuration() {
            return this;
        }
    }
}

