package io.snice.codecs.codec.gtp.gtpc.v2.tliv;

import io.snice.buffer.Buffer;
import io.snice.buffer.Buffers;
import io.snice.codecs.codec.gtp.gtpc.v2.tliv.TypeLengthInstanceValue;
import io.snice.codecs.codec.gtp.gtpc.v2.tliv.impl.BaseTliv;
import io.snice.codecs.codec.gtp.gtpc.v2.tliv.impl.RawTypeLengthInstanceValue;
import io.snice.codecs.codec.gtp.gtpc.v2.type.TbcdType;
import io.snice.codecs.codec.gtp.gtpc.v2.Gtp2InfoElement;

import static io.snice.preconditions.PreConditions.assertArgument;
import static io.snice.preconditions.PreConditions.assertNotNull;

/**
 * This file has been auto generated. Do not manually edit.
 * Please see the readme file in the codegen directory
 * for how to update and generate this file.
 *
 * @author jonas@jonasborjesson.com
 */
public interface Mei extends TypeLengthInstanceValue<TbcdType> {

    Gtp2InfoElement TYPE = Gtp2InfoElement.MEI;

    /**
     * The raw byte value of the Info Element. Useful when writing switch statements
     * since those needs a constant value.
     */
    int TYPE_VALUE = 75;

    static Mei frame(final Buffer buffer) {
        final var raw = RawTypeLengthInstanceValue.frame(buffer);
        return frame(raw);
    }

    static Mei frame(final RawTypeLengthInstanceValue raw) {
        assertNotNull(raw);
        assertArgument(raw.getType() == Mei.TYPE.getType(), "The given raw TLIV is not an MEI");
        final var value = TbcdType.parse(raw.getValue().getBuffer());
        return new DefaultMei(value, raw);
    }

    static Mei ofValue(final Buffer buffer) {
        final var value = TbcdType.ofValue(buffer);
        return ofValue(value);
    }

    static Mei ofValue(final Buffer buffer, final int instance) {
        final var value = TbcdType.ofValue(buffer);
        return ofValue(value, instance);
    }

    static Mei ofValue(final String buffer) {
        final var value = TbcdType.ofValue(buffer);
        return ofValue(value);
    }

    static Mei ofValue(final String buffer, final int instance) {
        final var value = TbcdType.ofValue(buffer);
        return ofValue(value, instance);
    }

    static Mei ofValue(final TbcdType value) {
        return ofValue(value, 0);
    }

    static Mei ofValue(final TbcdType value, final int instance) {
        final var raw = RawTypeLengthInstanceValue.create(TYPE, instance, value);
        return new DefaultMei(value, raw);
    }

    @Override
    default Mei ensure() {
        return this;
    }

    class DefaultMei extends BaseTliv<TbcdType> implements Mei {
        private DefaultMei(TbcdType value, RawTypeLengthInstanceValue raw) {
            super(value, raw);
        }

        public boolean isMei() {
            return true;
        }

        public Mei toMei() {
            return this;
        }
    }
}

