package io.snice.codecs.codec.gtp.gtpc.v2.tliv;

import io.snice.buffer.Buffer;
import io.snice.buffer.Buffers;
import io.snice.codecs.codec.gtp.gtpc.v2.tliv.TypeLengthInstanceValue;
import io.snice.codecs.codec.gtp.gtpc.v2.tliv.impl.BaseTliv;
import io.snice.codecs.codec.gtp.gtpc.v2.tliv.impl.RawTypeLengthInstanceValue;
import io.snice.codecs.codec.gtp.gtpc.v2.type.RawType;
import io.snice.codecs.codec.gtp.gtpc.v2.Gtp2InfoElement;

import static io.snice.preconditions.PreConditions.assertArgument;
import static io.snice.preconditions.PreConditions.assertNotNull;

/**
 * This file has been auto generated. Do not manually edit.
 * Please see the readme file in the codegen directory
 * for how to update and generate this file.
 *
 * @author jonas@jonasborjesson.com
 */
public interface MmContextGsmKeyTriplets extends TypeLengthInstanceValue<RawType> {

    Gtp2InfoElement TYPE = Gtp2InfoElement.MM_CONTEXT_GSM_KEY_TRIPLETS;

    /**
     * The raw byte value of the Info Element. Useful when writing switch statements
     * since those needs a constant value.
     */
    int TYPE_VALUE = 103;

    static MmContextGsmKeyTriplets frame(final Buffer buffer) {
        final var raw = RawTypeLengthInstanceValue.frame(buffer);
        return frame(raw);
    }

    static MmContextGsmKeyTriplets frame(final RawTypeLengthInstanceValue raw) {
        assertNotNull(raw);
        assertArgument(raw.getType() == MmContextGsmKeyTriplets.TYPE.getType(), "The given raw TLIV is not an MM_CONTEXT_GSM_KEY_TRIPLETS");
        final var value = RawType.parse(raw.getValue().getBuffer());
        return new DefaultMmContextGsmKeyTriplets(value, raw);
    }

    static MmContextGsmKeyTriplets ofValue(final Buffer buffer) {
        final var value = RawType.ofValue(buffer);
        return ofValue(value);
    }

    static MmContextGsmKeyTriplets ofValue(final Buffer buffer, final int instance) {
        final var value = RawType.ofValue(buffer);
        return ofValue(value, instance);
    }

    static MmContextGsmKeyTriplets ofValue(final String buffer) {
        final var value = RawType.ofValue(buffer);
        return ofValue(value);
    }

    static MmContextGsmKeyTriplets ofValue(final String buffer, final int instance) {
        final var value = RawType.ofValue(buffer);
        return ofValue(value, instance);
    }

    static MmContextGsmKeyTriplets ofValue(final RawType value) {
        return ofValue(value, 0);
    }

    static MmContextGsmKeyTriplets ofValue(final RawType value, final int instance) {
        final var raw = RawTypeLengthInstanceValue.create(TYPE, instance, value);
        return new DefaultMmContextGsmKeyTriplets(value, raw);
    }

    @Override
    default MmContextGsmKeyTriplets ensure() {
        return this;
    }

    class DefaultMmContextGsmKeyTriplets extends BaseTliv<RawType> implements MmContextGsmKeyTriplets {
        private DefaultMmContextGsmKeyTriplets(RawType value, RawTypeLengthInstanceValue raw) {
            super(value, raw);
        }

        public boolean isMmContextGsmKeyTriplets() {
            return true;
        }

        public MmContextGsmKeyTriplets toMmContextGsmKeyTriplets() {
            return this;
        }
    }
}

