package io.snice.codecs.codec.gtp.gtpc.v2.tliv;

import io.snice.buffer.Buffer;
import io.snice.buffer.Buffers;
import io.snice.codecs.codec.gtp.gtpc.v2.tliv.TypeLengthInstanceValue;
import io.snice.codecs.codec.gtp.gtpc.v2.tliv.impl.BaseTliv;
import io.snice.codecs.codec.gtp.gtpc.v2.tliv.impl.RawTypeLengthInstanceValue;
import io.snice.codecs.codec.gtp.gtpc.v2.type.RawType;
import io.snice.codecs.codec.gtp.gtpc.v2.Gtp2InfoElement;

import static io.snice.preconditions.PreConditions.assertArgument;
import static io.snice.preconditions.PreConditions.assertNotNull;

/**
 * This file has been auto generated. Do not manually edit.
 * Please see the readme file in the codegen directory
 * for how to update and generate this file.
 *
 * @author jonas@jonasborjesson.com
 */
public interface MmContextGsmKeyUsedCipherQuintuplets extends TypeLengthInstanceValue<RawType> {

    Gtp2InfoElement TYPE = Gtp2InfoElement.MM_CONTEXT_GSM_KEY_USED_CIPHER_QUINTUPLETS;

    /**
     * The raw byte value of the Info Element. Useful when writing switch statements
     * since those needs a constant value.
     */
    int TYPE_VALUE = 105;

    static MmContextGsmKeyUsedCipherQuintuplets frame(final Buffer buffer) {
        final var raw = RawTypeLengthInstanceValue.frame(buffer);
        return frame(raw);
    }

    static MmContextGsmKeyUsedCipherQuintuplets frame(final RawTypeLengthInstanceValue raw) {
        assertNotNull(raw);
        assertArgument(raw.getType() == MmContextGsmKeyUsedCipherQuintuplets.TYPE.getType(), "The given raw TLIV is not an MM_CONTEXT_GSM_KEY_USED_CIPHER_QUINTUPLETS");
        final var value = RawType.parse(raw.getValue().getBuffer());
        return new DefaultMmContextGsmKeyUsedCipherQuintuplets(value, raw);
    }

    static MmContextGsmKeyUsedCipherQuintuplets ofValue(final Buffer buffer) {
        final var value = RawType.ofValue(buffer);
        return ofValue(value);
    }

    static MmContextGsmKeyUsedCipherQuintuplets ofValue(final Buffer buffer, final int instance) {
        final var value = RawType.ofValue(buffer);
        return ofValue(value, instance);
    }

    static MmContextGsmKeyUsedCipherQuintuplets ofValue(final String buffer) {
        final var value = RawType.ofValue(buffer);
        return ofValue(value);
    }

    static MmContextGsmKeyUsedCipherQuintuplets ofValue(final String buffer, final int instance) {
        final var value = RawType.ofValue(buffer);
        return ofValue(value, instance);
    }

    static MmContextGsmKeyUsedCipherQuintuplets ofValue(final RawType value) {
        return ofValue(value, 0);
    }

    static MmContextGsmKeyUsedCipherQuintuplets ofValue(final RawType value, final int instance) {
        final var raw = RawTypeLengthInstanceValue.create(TYPE, instance, value);
        return new DefaultMmContextGsmKeyUsedCipherQuintuplets(value, raw);
    }

    @Override
    default MmContextGsmKeyUsedCipherQuintuplets ensure() {
        return this;
    }

    class DefaultMmContextGsmKeyUsedCipherQuintuplets extends BaseTliv<RawType> implements MmContextGsmKeyUsedCipherQuintuplets {
        private DefaultMmContextGsmKeyUsedCipherQuintuplets(RawType value, RawTypeLengthInstanceValue raw) {
            super(value, raw);
        }

        public boolean isMmContextGsmKeyUsedCipherQuintuplets() {
            return true;
        }

        public MmContextGsmKeyUsedCipherQuintuplets toMmContextGsmKeyUsedCipherQuintuplets() {
            return this;
        }
    }
}

