package io.snice.codecs.codec.gtp.gtpc.v2.tliv;

import io.snice.buffer.Buffer;
import io.snice.buffer.Buffers;
import io.snice.codecs.codec.gtp.gtpc.v2.tliv.TypeLengthInstanceValue;
import io.snice.codecs.codec.gtp.gtpc.v2.tliv.impl.BaseTliv;
import io.snice.codecs.codec.gtp.gtpc.v2.tliv.impl.RawTypeLengthInstanceValue;
import io.snice.codecs.codec.gtp.gtpc.v2.type.RawType;
import io.snice.codecs.codec.gtp.gtpc.v2.Gtp2InfoElement;

import static io.snice.preconditions.PreConditions.assertArgument;
import static io.snice.preconditions.PreConditions.assertNotNull;

/**
 * This file has been auto generated. Do not manually edit.
 * Please see the readme file in the codegen directory
 * for how to update and generate this file.
 *
 * @author jonas@jonasborjesson.com
 */
public interface MmContextUmtsKeyQuadrupletsQuintuplets extends TypeLengthInstanceValue<RawType> {

    Gtp2InfoElement TYPE = Gtp2InfoElement.MM_CONTEXT_UMTS_KEY_QUADRUPLETS_QUINTUPLETS;

    /**
     * The raw byte value of the Info Element. Useful when writing switch statements
     * since those needs a constant value.
     */
    int TYPE_VALUE = 108;

    static MmContextUmtsKeyQuadrupletsQuintuplets frame(final Buffer buffer) {
        final var raw = RawTypeLengthInstanceValue.frame(buffer);
        return frame(raw);
    }

    static MmContextUmtsKeyQuadrupletsQuintuplets frame(final RawTypeLengthInstanceValue raw) {
        assertNotNull(raw);
        assertArgument(raw.getType() == MmContextUmtsKeyQuadrupletsQuintuplets.TYPE.getType(), "The given raw TLIV is not an MM_CONTEXT_UMTS_KEY_QUADRUPLETS_QUINTUPLETS");
        final var value = RawType.parse(raw.getValue().getBuffer());
        return new DefaultMmContextUmtsKeyQuadrupletsQuintuplets(value, raw);
    }

    static MmContextUmtsKeyQuadrupletsQuintuplets ofValue(final Buffer buffer) {
        final var value = RawType.ofValue(buffer);
        return ofValue(value);
    }

    static MmContextUmtsKeyQuadrupletsQuintuplets ofValue(final Buffer buffer, final int instance) {
        final var value = RawType.ofValue(buffer);
        return ofValue(value, instance);
    }

    static MmContextUmtsKeyQuadrupletsQuintuplets ofValue(final String buffer) {
        final var value = RawType.ofValue(buffer);
        return ofValue(value);
    }

    static MmContextUmtsKeyQuadrupletsQuintuplets ofValue(final String buffer, final int instance) {
        final var value = RawType.ofValue(buffer);
        return ofValue(value, instance);
    }

    static MmContextUmtsKeyQuadrupletsQuintuplets ofValue(final RawType value) {
        return ofValue(value, 0);
    }

    static MmContextUmtsKeyQuadrupletsQuintuplets ofValue(final RawType value, final int instance) {
        final var raw = RawTypeLengthInstanceValue.create(TYPE, instance, value);
        return new DefaultMmContextUmtsKeyQuadrupletsQuintuplets(value, raw);
    }

    @Override
    default MmContextUmtsKeyQuadrupletsQuintuplets ensure() {
        return this;
    }

    class DefaultMmContextUmtsKeyQuadrupletsQuintuplets extends BaseTliv<RawType> implements MmContextUmtsKeyQuadrupletsQuintuplets {
        private DefaultMmContextUmtsKeyQuadrupletsQuintuplets(RawType value, RawTypeLengthInstanceValue raw) {
            super(value, raw);
        }

        public boolean isMmContextUmtsKeyQuadrupletsQuintuplets() {
            return true;
        }

        public MmContextUmtsKeyQuadrupletsQuintuplets toMmContextUmtsKeyQuadrupletsQuintuplets() {
            return this;
        }
    }
}

