package io.snice.codecs.codec.gtp.gtpc.v2.tliv;

import io.snice.buffer.Buffer;
import io.snice.buffer.Buffers;
import io.snice.codecs.codec.gtp.gtpc.v2.tliv.TypeLengthInstanceValue;
import io.snice.codecs.codec.gtp.gtpc.v2.tliv.impl.BaseTliv;
import io.snice.codecs.codec.gtp.gtpc.v2.tliv.impl.RawTypeLengthInstanceValue;
import io.snice.codecs.codec.gtp.gtpc.v2.type.RawType;
import io.snice.codecs.codec.gtp.gtpc.v2.Gtp2InfoElement;

import static io.snice.preconditions.PreConditions.assertArgument;
import static io.snice.preconditions.PreConditions.assertNotNull;

/**
 * This file has been auto generated. Do not manually edit.
 * Please see the readme file in the codegen directory
 * for how to update and generate this file.
 *
 * @author jonas@jonasborjesson.com
 */
public interface MmContextUmtsKeyQuintuplets extends TypeLengthInstanceValue<RawType> {

    Gtp2InfoElement TYPE = Gtp2InfoElement.MM_CONTEXT_UMTS_KEY_QUINTUPLETS;

    /**
     * The raw byte value of the Info Element. Useful when writing switch statements
     * since those needs a constant value.
     */
    int TYPE_VALUE = 106;

    static MmContextUmtsKeyQuintuplets frame(final Buffer buffer) {
        final var raw = RawTypeLengthInstanceValue.frame(buffer);
        return frame(raw);
    }

    static MmContextUmtsKeyQuintuplets frame(final RawTypeLengthInstanceValue raw) {
        assertNotNull(raw);
        assertArgument(raw.getType() == MmContextUmtsKeyQuintuplets.TYPE.getType(), "The given raw TLIV is not an MM_CONTEXT_UMTS_KEY_QUINTUPLETS");
        final var value = RawType.parse(raw.getValue().getBuffer());
        return new DefaultMmContextUmtsKeyQuintuplets(value, raw);
    }

    static MmContextUmtsKeyQuintuplets ofValue(final Buffer buffer) {
        final var value = RawType.ofValue(buffer);
        return ofValue(value);
    }

    static MmContextUmtsKeyQuintuplets ofValue(final Buffer buffer, final int instance) {
        final var value = RawType.ofValue(buffer);
        return ofValue(value, instance);
    }

    static MmContextUmtsKeyQuintuplets ofValue(final String buffer) {
        final var value = RawType.ofValue(buffer);
        return ofValue(value);
    }

    static MmContextUmtsKeyQuintuplets ofValue(final String buffer, final int instance) {
        final var value = RawType.ofValue(buffer);
        return ofValue(value, instance);
    }

    static MmContextUmtsKeyQuintuplets ofValue(final RawType value) {
        return ofValue(value, 0);
    }

    static MmContextUmtsKeyQuintuplets ofValue(final RawType value, final int instance) {
        final var raw = RawTypeLengthInstanceValue.create(TYPE, instance, value);
        return new DefaultMmContextUmtsKeyQuintuplets(value, raw);
    }

    @Override
    default MmContextUmtsKeyQuintuplets ensure() {
        return this;
    }

    class DefaultMmContextUmtsKeyQuintuplets extends BaseTliv<RawType> implements MmContextUmtsKeyQuintuplets {
        private DefaultMmContextUmtsKeyQuintuplets(RawType value, RawTypeLengthInstanceValue raw) {
            super(value, raw);
        }

        public boolean isMmContextUmtsKeyQuintuplets() {
            return true;
        }

        public MmContextUmtsKeyQuintuplets toMmContextUmtsKeyQuintuplets() {
            return this;
        }
    }
}

