package io.snice.codecs.codec.gtp.gtpc.v2.tliv;

import io.snice.buffer.Buffer;
import io.snice.buffer.Buffers;
import io.snice.codecs.codec.gtp.gtpc.v2.tliv.TypeLengthInstanceValue;
import io.snice.codecs.codec.gtp.gtpc.v2.tliv.impl.BaseTliv;
import io.snice.codecs.codec.gtp.gtpc.v2.tliv.impl.RawTypeLengthInstanceValue;
import io.snice.codecs.codec.gtp.gtpc.v2.type.TbcdType;
import io.snice.codecs.codec.gtp.gtpc.v2.Gtp2InfoElement;

import static io.snice.preconditions.PreConditions.assertArgument;
import static io.snice.preconditions.PreConditions.assertNotNull;

/**
 * This file has been auto generated. Do not manually edit.
 * Please see the readme file in the codegen directory
 * for how to update and generate this file.
 *
 * @author jonas@jonasborjesson.com
 */
public interface Msisdn extends TypeLengthInstanceValue<TbcdType> {

    Gtp2InfoElement TYPE = Gtp2InfoElement.MSISDN;

    /**
     * The raw byte value of the Info Element. Useful when writing switch statements
     * since those needs a constant value.
     */
    int TYPE_VALUE = 76;

    static Msisdn frame(final Buffer buffer) {
        final var raw = RawTypeLengthInstanceValue.frame(buffer);
        return frame(raw);
    }

    static Msisdn frame(final RawTypeLengthInstanceValue raw) {
        assertNotNull(raw);
        assertArgument(raw.getType() == Msisdn.TYPE.getType(), "The given raw TLIV is not an MSISDN");
        final var value = TbcdType.parse(raw.getValue().getBuffer());
        return new DefaultMsisdn(value, raw);
    }

    static Msisdn ofValue(final Buffer buffer) {
        final var value = TbcdType.ofValue(buffer);
        return ofValue(value);
    }

    static Msisdn ofValue(final Buffer buffer, final int instance) {
        final var value = TbcdType.ofValue(buffer);
        return ofValue(value, instance);
    }

    static Msisdn ofValue(final String buffer) {
        final var value = TbcdType.ofValue(buffer);
        return ofValue(value);
    }

    static Msisdn ofValue(final String buffer, final int instance) {
        final var value = TbcdType.ofValue(buffer);
        return ofValue(value, instance);
    }

    static Msisdn ofValue(final TbcdType value) {
        return ofValue(value, 0);
    }

    static Msisdn ofValue(final TbcdType value, final int instance) {
        final var raw = RawTypeLengthInstanceValue.create(TYPE, instance, value);
        return new DefaultMsisdn(value, raw);
    }

    @Override
    default Msisdn ensure() {
        return this;
    }

    class DefaultMsisdn extends BaseTliv<TbcdType> implements Msisdn {
        private DefaultMsisdn(TbcdType value, RawTypeLengthInstanceValue raw) {
            super(value, raw);
        }

        public boolean isMsisdn() {
            return true;
        }

        public Msisdn toMsisdn() {
            return this;
        }
    }
}

