package io.snice.codecs.codec.gtp.gtpc.v2.tliv;

import io.snice.buffer.Buffer;
import io.snice.buffer.Buffers;
import io.snice.codecs.codec.gtp.gtpc.v2.tliv.TypeLengthInstanceValue;
import io.snice.codecs.codec.gtp.gtpc.v2.tliv.impl.BaseTliv;
import io.snice.codecs.codec.gtp.gtpc.v2.tliv.impl.RawTypeLengthInstanceValue;
import io.snice.codecs.codec.gtp.gtpc.v2.type.RawType;
import io.snice.codecs.codec.gtp.gtpc.v2.Gtp2InfoElement;

import static io.snice.preconditions.PreConditions.assertArgument;
import static io.snice.preconditions.PreConditions.assertNotNull;

/**
 * This file has been auto generated. Do not manually edit.
 * Please see the readme file in the codegen directory
 * for how to update and generate this file.
 *
 * @author jonas@jonasborjesson.com
 */
public interface NodeFeatures extends TypeLengthInstanceValue<RawType> {

    Gtp2InfoElement TYPE = Gtp2InfoElement.NODE_FEATURES;

    /**
     * The raw byte value of the Info Element. Useful when writing switch statements
     * since those needs a constant value.
     */
    int TYPE_VALUE = 152;

    static NodeFeatures frame(final Buffer buffer) {
        final var raw = RawTypeLengthInstanceValue.frame(buffer);
        return frame(raw);
    }

    static NodeFeatures frame(final RawTypeLengthInstanceValue raw) {
        assertNotNull(raw);
        assertArgument(raw.getType() == NodeFeatures.TYPE.getType(), "The given raw TLIV is not an NODE_FEATURES");
        final var value = RawType.parse(raw.getValue().getBuffer());
        return new DefaultNodeFeatures(value, raw);
    }

    static NodeFeatures ofValue(final Buffer buffer) {
        final var value = RawType.ofValue(buffer);
        return ofValue(value);
    }

    static NodeFeatures ofValue(final Buffer buffer, final int instance) {
        final var value = RawType.ofValue(buffer);
        return ofValue(value, instance);
    }

    static NodeFeatures ofValue(final String buffer) {
        final var value = RawType.ofValue(buffer);
        return ofValue(value);
    }

    static NodeFeatures ofValue(final String buffer, final int instance) {
        final var value = RawType.ofValue(buffer);
        return ofValue(value, instance);
    }

    static NodeFeatures ofValue(final RawType value) {
        return ofValue(value, 0);
    }

    static NodeFeatures ofValue(final RawType value, final int instance) {
        final var raw = RawTypeLengthInstanceValue.create(TYPE, instance, value);
        return new DefaultNodeFeatures(value, raw);
    }

    @Override
    default NodeFeatures ensure() {
        return this;
    }

    class DefaultNodeFeatures extends BaseTliv<RawType> implements NodeFeatures {
        private DefaultNodeFeatures(RawType value, RawTypeLengthInstanceValue raw) {
            super(value, raw);
        }

        public boolean isNodeFeatures() {
            return true;
        }

        public NodeFeatures toNodeFeatures() {
            return this;
        }
    }
}

