package io.snice.codecs.codec.gtp.gtpc.v2.tliv;

import io.snice.buffer.Buffer;
import io.snice.buffer.Buffers;
import io.snice.codecs.codec.gtp.gtpc.v2.tliv.TypeLengthInstanceValue;
import io.snice.codecs.codec.gtp.gtpc.v2.tliv.impl.BaseTliv;
import io.snice.codecs.codec.gtp.gtpc.v2.tliv.impl.RawTypeLengthInstanceValue;
import io.snice.codecs.codec.gtp.gtpc.v2.type.PaaType;
import io.snice.codecs.codec.gtp.gtpc.v2.Gtp2InfoElement;

import static io.snice.preconditions.PreConditions.assertArgument;
import static io.snice.preconditions.PreConditions.assertNotNull;

/**
 * This file has been auto generated. Do not manually edit.
 * Please see the readme file in the codegen directory
 * for how to update and generate this file.
 *
 * @author jonas@jonasborjesson.com
 */
public interface Paa extends TypeLengthInstanceValue<PaaType> {

    Gtp2InfoElement TYPE = Gtp2InfoElement.PAA;

    /**
     * The raw byte value of the Info Element. Useful when writing switch statements
     * since those needs a constant value.
     */
    int TYPE_VALUE = 79;

    static Paa frame(final Buffer buffer) {
        final var raw = RawTypeLengthInstanceValue.frame(buffer);
        return frame(raw);
    }

    static Paa frame(final RawTypeLengthInstanceValue raw) {
        assertNotNull(raw);
        assertArgument(raw.getType() == Paa.TYPE.getType(), "The given raw TLIV is not an PAA");
        final var value = PaaType.parse(raw.getValue().getBuffer());
        return new DefaultPaa(value, raw);
    }

    static Paa ofValue(final Buffer buffer) {
        final var value = PaaType.ofValue(buffer);
        return ofValue(value);
    }

    static Paa ofValue(final Buffer buffer, final int instance) {
        final var value = PaaType.ofValue(buffer);
        return ofValue(value, instance);
    }

    static Paa ofValue(final String buffer) {
        final var value = PaaType.ofValue(buffer);
        return ofValue(value);
    }

    static Paa ofValue(final String buffer, final int instance) {
        final var value = PaaType.ofValue(buffer);
        return ofValue(value, instance);
    }

    static Paa ofValue(final PaaType value) {
        return ofValue(value, 0);
    }

    static Paa ofValue(final PaaType value, final int instance) {
        final var raw = RawTypeLengthInstanceValue.create(TYPE, instance, value);
        return new DefaultPaa(value, raw);
    }

    @Override
    default Paa ensure() {
        return this;
    }

    class DefaultPaa extends BaseTliv<PaaType> implements Paa {
        private DefaultPaa(PaaType value, RawTypeLengthInstanceValue raw) {
            super(value, raw);
        }

        public boolean isPaa() {
            return true;
        }

        public Paa toPaa() {
            return this;
        }
    }
}

