package io.snice.codecs.codec.gtp.gtpc.v2.tliv;

import io.snice.buffer.Buffer;
import io.snice.buffer.Buffers;
import io.snice.codecs.codec.gtp.gtpc.v2.tliv.TypeLengthInstanceValue;
import io.snice.codecs.codec.gtp.gtpc.v2.tliv.impl.BaseTliv;
import io.snice.codecs.codec.gtp.gtpc.v2.tliv.impl.RawTypeLengthInstanceValue;
import io.snice.codecs.codec.gtp.gtpc.v2.type.RawType;
import io.snice.codecs.codec.gtp.gtpc.v2.Gtp2InfoElement;

import static io.snice.preconditions.PreConditions.assertArgument;
import static io.snice.preconditions.PreConditions.assertNotNull;

/**
 * This file has been auto generated. Do not manually edit.
 * Please see the readme file in the codegen directory
 * for how to update and generate this file.
 *
 * @author jonas@jonasborjesson.com
 */
public interface Pco extends TypeLengthInstanceValue<RawType> {

    Gtp2InfoElement TYPE = Gtp2InfoElement.PCO;

    /**
     * The raw byte value of the Info Element. Useful when writing switch statements
     * since those needs a constant value.
     */
    int TYPE_VALUE = 78;

    static Pco frame(final Buffer buffer) {
        final var raw = RawTypeLengthInstanceValue.frame(buffer);
        return frame(raw);
    }

    static Pco frame(final RawTypeLengthInstanceValue raw) {
        assertNotNull(raw);
        assertArgument(raw.getType() == Pco.TYPE.getType(), "The given raw TLIV is not an PCO");
        final var value = RawType.parse(raw.getValue().getBuffer());
        return new DefaultPco(value, raw);
    }

    static Pco ofValue(final Buffer buffer) {
        final var value = RawType.ofValue(buffer);
        return ofValue(value);
    }

    static Pco ofValue(final Buffer buffer, final int instance) {
        final var value = RawType.ofValue(buffer);
        return ofValue(value, instance);
    }

    static Pco ofValue(final String buffer) {
        final var value = RawType.ofValue(buffer);
        return ofValue(value);
    }

    static Pco ofValue(final String buffer, final int instance) {
        final var value = RawType.ofValue(buffer);
        return ofValue(value, instance);
    }

    static Pco ofValue(final RawType value) {
        return ofValue(value, 0);
    }

    static Pco ofValue(final RawType value, final int instance) {
        final var raw = RawTypeLengthInstanceValue.create(TYPE, instance, value);
        return new DefaultPco(value, raw);
    }

    @Override
    default Pco ensure() {
        return this;
    }

    class DefaultPco extends BaseTliv<RawType> implements Pco {
        private DefaultPco(RawType value, RawTypeLengthInstanceValue raw) {
            super(value, raw);
        }

        public boolean isPco() {
            return true;
        }

        public Pco toPco() {
            return this;
        }
    }
}

