package io.snice.codecs.codec.gtp.gtpc.v2.tliv;

import io.snice.buffer.Buffer;
import io.snice.buffer.Buffers;
import io.snice.codecs.codec.gtp.gtpc.v2.tliv.TypeLengthInstanceValue;
import io.snice.codecs.codec.gtp.gtpc.v2.tliv.impl.BaseTliv;
import io.snice.codecs.codec.gtp.gtpc.v2.tliv.impl.RawTypeLengthInstanceValue;
import io.snice.codecs.codec.gtp.gtpc.v2.type.PdnType;
import io.snice.codecs.codec.gtp.gtpc.v2.Gtp2InfoElement;

import static io.snice.preconditions.PreConditions.assertArgument;
import static io.snice.preconditions.PreConditions.assertNotNull;

/**
 * This file has been auto generated. Do not manually edit.
 * Please see the readme file in the codegen directory
 * for how to update and generate this file.
 *
 * @author jonas@jonasborjesson.com
 */
public interface Pdn extends TypeLengthInstanceValue<PdnType> {

    Gtp2InfoElement TYPE = Gtp2InfoElement.PDN;

    /**
     * The raw byte value of the Info Element. Useful when writing switch statements
     * since those needs a constant value.
     */
    int TYPE_VALUE = 99;

    static Pdn frame(final Buffer buffer) {
        final var raw = RawTypeLengthInstanceValue.frame(buffer);
        return frame(raw);
    }

    static Pdn frame(final RawTypeLengthInstanceValue raw) {
        assertNotNull(raw);
        assertArgument(raw.getType() == Pdn.TYPE.getType(), "The given raw TLIV is not an PDN");
        final var value = PdnType.parse(raw.getValue().getBuffer());
        return new DefaultPdn(value, raw);
    }

    static Pdn ofValue(final Buffer buffer) {
        final var value = PdnType.ofValue(buffer);
        return ofValue(value);
    }

    static Pdn ofValue(final Buffer buffer, final int instance) {
        final var value = PdnType.ofValue(buffer);
        return ofValue(value, instance);
    }

    static Pdn ofValue(final String buffer) {
        final var value = PdnType.ofValue(buffer);
        return ofValue(value);
    }

    static Pdn ofValue(final String buffer, final int instance) {
        final var value = PdnType.ofValue(buffer);
        return ofValue(value, instance);
    }

    static Pdn ofValue(final PdnType value) {
        return ofValue(value, 0);
    }

    static Pdn ofValue(final PdnType value, final int instance) {
        final var raw = RawTypeLengthInstanceValue.create(TYPE, instance, value);
        return new DefaultPdn(value, raw);
    }

    @Override
    default Pdn ensure() {
        return this;
    }

    class DefaultPdn extends BaseTliv<PdnType> implements Pdn {
        private DefaultPdn(PdnType value, RawTypeLengthInstanceValue raw) {
            super(value, raw);
        }

        public boolean isPdn() {
            return true;
        }

        public Pdn toPdn() {
            return this;
        }
    }
}

