package io.snice.codecs.codec.gtp.gtpc.v2.tliv;

import io.snice.buffer.Buffer;
import io.snice.buffer.Buffers;
import io.snice.codecs.codec.gtp.gtpc.v2.tliv.TypeLengthInstanceValue;
import io.snice.codecs.codec.gtp.gtpc.v2.tliv.impl.BaseTliv;
import io.snice.codecs.codec.gtp.gtpc.v2.tliv.impl.RawTypeLengthInstanceValue;
import io.snice.codecs.codec.gtp.gtpc.v2.type.RawType;
import io.snice.codecs.codec.gtp.gtpc.v2.Gtp2InfoElement;

import static io.snice.preconditions.PreConditions.assertArgument;
import static io.snice.preconditions.PreConditions.assertNotNull;

/**
 * This file has been auto generated. Do not manually edit.
 * Please see the readme file in the codegen directory
 * for how to update and generate this file.
 *
 * @author jonas@jonasborjesson.com
 */
public interface PresenceReportingAreaInformation extends TypeLengthInstanceValue<RawType> {

    Gtp2InfoElement TYPE = Gtp2InfoElement.PRESENCE_REPORTING_AREA_INFORMATION;

    /**
     * The raw byte value of the Info Element. Useful when writing switch statements
     * since those needs a constant value.
     */
    int TYPE_VALUE = 178;

    static PresenceReportingAreaInformation frame(final Buffer buffer) {
        final var raw = RawTypeLengthInstanceValue.frame(buffer);
        return frame(raw);
    }

    static PresenceReportingAreaInformation frame(final RawTypeLengthInstanceValue raw) {
        assertNotNull(raw);
        assertArgument(raw.getType() == PresenceReportingAreaInformation.TYPE.getType(), "The given raw TLIV is not an PRESENCE_REPORTING_AREA_INFORMATION");
        final var value = RawType.parse(raw.getValue().getBuffer());
        return new DefaultPresenceReportingAreaInformation(value, raw);
    }

    static PresenceReportingAreaInformation ofValue(final Buffer buffer) {
        final var value = RawType.ofValue(buffer);
        return ofValue(value);
    }

    static PresenceReportingAreaInformation ofValue(final Buffer buffer, final int instance) {
        final var value = RawType.ofValue(buffer);
        return ofValue(value, instance);
    }

    static PresenceReportingAreaInformation ofValue(final String buffer) {
        final var value = RawType.ofValue(buffer);
        return ofValue(value);
    }

    static PresenceReportingAreaInformation ofValue(final String buffer, final int instance) {
        final var value = RawType.ofValue(buffer);
        return ofValue(value, instance);
    }

    static PresenceReportingAreaInformation ofValue(final RawType value) {
        return ofValue(value, 0);
    }

    static PresenceReportingAreaInformation ofValue(final RawType value, final int instance) {
        final var raw = RawTypeLengthInstanceValue.create(TYPE, instance, value);
        return new DefaultPresenceReportingAreaInformation(value, raw);
    }

    @Override
    default PresenceReportingAreaInformation ensure() {
        return this;
    }

    class DefaultPresenceReportingAreaInformation extends BaseTliv<RawType> implements PresenceReportingAreaInformation {
        private DefaultPresenceReportingAreaInformation(RawType value, RawTypeLengthInstanceValue raw) {
            super(value, raw);
        }

        public boolean isPresenceReportingAreaInformation() {
            return true;
        }

        public PresenceReportingAreaInformation toPresenceReportingAreaInformation() {
            return this;
        }
    }
}

