package io.snice.codecs.codec.gtp.gtpc.v2.tliv;

import io.snice.buffer.Buffer;
import io.snice.buffer.Buffers;
import io.snice.codecs.codec.gtp.gtpc.v2.tliv.TypeLengthInstanceValue;
import io.snice.codecs.codec.gtp.gtpc.v2.tliv.impl.BaseTliv;
import io.snice.codecs.codec.gtp.gtpc.v2.tliv.impl.RawTypeLengthInstanceValue;
import io.snice.codecs.codec.gtp.gtpc.v2.type.RatType;
import io.snice.codecs.codec.gtp.gtpc.v2.Gtp2InfoElement;

import static io.snice.preconditions.PreConditions.assertArgument;
import static io.snice.preconditions.PreConditions.assertNotNull;

/**
 * This file has been auto generated. Do not manually edit.
 * Please see the readme file in the codegen directory
 * for how to update and generate this file.
 *
 * @author jonas@jonasborjesson.com
 */
public interface Rat extends TypeLengthInstanceValue<RatType> {

    Gtp2InfoElement TYPE = Gtp2InfoElement.RAT;

    /**
     * The raw byte value of the Info Element. Useful when writing switch statements
     * since those needs a constant value.
     */
    int TYPE_VALUE = 82;

    static Rat frame(final Buffer buffer) {
        final var raw = RawTypeLengthInstanceValue.frame(buffer);
        return frame(raw);
    }

    static Rat frame(final RawTypeLengthInstanceValue raw) {
        assertNotNull(raw);
        assertArgument(raw.getType() == Rat.TYPE.getType(), "The given raw TLIV is not an RAT");
        final var value = RatType.parse(raw.getValue().getBuffer());
        return new DefaultRat(value, raw);
    }

    static Rat ofValue(final Buffer buffer) {
        final var value = RatType.ofValue(buffer);
        return ofValue(value);
    }

    static Rat ofValue(final Buffer buffer, final int instance) {
        final var value = RatType.ofValue(buffer);
        return ofValue(value, instance);
    }

    static Rat ofValue(final String buffer) {
        final var value = RatType.ofValue(buffer);
        return ofValue(value);
    }

    static Rat ofValue(final String buffer, final int instance) {
        final var value = RatType.ofValue(buffer);
        return ofValue(value, instance);
    }

    static Rat ofValue(final RatType value) {
        return ofValue(value, 0);
    }

    static Rat ofValue(final RatType value, final int instance) {
        final var raw = RawTypeLengthInstanceValue.create(TYPE, instance, value);
        return new DefaultRat(value, raw);
    }

    @Override
    default Rat ensure() {
        return this;
    }

    class DefaultRat extends BaseTliv<RatType> implements Rat {
        private DefaultRat(RatType value, RawTypeLengthInstanceValue raw) {
            super(value, raw);
        }

        public boolean isRat() {
            return true;
        }

        public Rat toRat() {
            return this;
        }
    }
}

