package io.snice.codecs.codec.gtp.gtpc.v2.tliv;

import io.snice.buffer.Buffer;
import io.snice.buffer.Buffers;
import io.snice.codecs.codec.gtp.gtpc.v2.tliv.TypeLengthInstanceValue;
import io.snice.codecs.codec.gtp.gtpc.v2.tliv.impl.BaseTliv;
import io.snice.codecs.codec.gtp.gtpc.v2.tliv.impl.RawTypeLengthInstanceValue;
import io.snice.codecs.codec.gtp.gtpc.v2.type.CounterType;
import io.snice.codecs.codec.gtp.gtpc.v2.Gtp2InfoElement;

import static io.snice.preconditions.PreConditions.assertArgument;
import static io.snice.preconditions.PreConditions.assertNotNull;

/**
 * This file has been auto generated. Do not manually edit.
 * Please see the readme file in the codegen directory
 * for how to update and generate this file.
 *
 * @author jonas@jonasborjesson.com
 */
public interface Recovery extends TypeLengthInstanceValue<CounterType> {

    Gtp2InfoElement TYPE = Gtp2InfoElement.RECOVERY;

    /**
     * The raw byte value of the Info Element. Useful when writing switch statements
     * since those needs a constant value.
     */
    int TYPE_VALUE = 3;

    static Recovery frame(final Buffer buffer) {
        final var raw = RawTypeLengthInstanceValue.frame(buffer);
        return frame(raw);
    }

    static Recovery frame(final RawTypeLengthInstanceValue raw) {
        assertNotNull(raw);
        assertArgument(raw.getType() == Recovery.TYPE.getType(), "The given raw TLIV is not an RECOVERY");
        final var value = CounterType.parse(raw.getValue().getBuffer());
        return new DefaultRecovery(value, raw);
    }

    static Recovery ofValue(final Buffer buffer) {
        final var value = CounterType.ofValue(buffer);
        return ofValue(value);
    }

    static Recovery ofValue(final Buffer buffer, final int instance) {
        final var value = CounterType.ofValue(buffer);
        return ofValue(value, instance);
    }

    static Recovery ofValue(final String buffer) {
        final var value = CounterType.ofValue(buffer);
        return ofValue(value);
    }

    static Recovery ofValue(final String buffer, final int instance) {
        final var value = CounterType.ofValue(buffer);
        return ofValue(value, instance);
    }

    static Recovery ofValue(final CounterType value) {
        return ofValue(value, 0);
    }

    static Recovery ofValue(final CounterType value, final int instance) {
        final var raw = RawTypeLengthInstanceValue.create(TYPE, instance, value);
        return new DefaultRecovery(value, raw);
    }

    @Override
    default Recovery ensure() {
        return this;
    }

    class DefaultRecovery extends BaseTliv<CounterType> implements Recovery {
        private DefaultRecovery(CounterType value, RawTypeLengthInstanceValue raw) {
            super(value, raw);
        }

        public boolean isRecovery() {
            return true;
        }

        public Recovery toRecovery() {
            return this;
        }
    }
}

